package com.xebialabs.xlplatform.cluster.membership.storage

import com.xebialabs.xlplatform.cluster.DataSourceConfig
import com.xebialabs.xlplatform.cluster.membership.storage.ClusterMembershipManagement.{Result, Success}

import scala.concurrent.duration.FiniteDuration
import scala.concurrent.{ExecutionContext, Future}

class ClusterMembershipMySQLDialect(clusterMembershipDataSource: DataSourceConfig, ttl: FiniteDuration, failFast: Boolean = true)
  extends ClusterMembershipSQLManagement(clusterMembershipDataSource, ttl, failFast) {
  override def driverName: String = "com.mysql.jdbc.Driver"

  override def createManagementInfra()(implicit executionContext: ExecutionContext): Future[Result] = {
    Future {
      withConnection { con =>
        con.prepareStatement(
          """
            |CREATE TABLE IF NOT EXISTS cluster_members(
            |  protocol VARCHAR(255) NOT NULL,
            |  `system` VARCHAR(255) NOT NULL,
            |  host VARCHAR(255) NOT NULL,
            |  port INT NOT NULL,
            |  ttl TIMESTAMP NOT NULL,
            |  PRIMARY KEY (protocol, `system`, host, port))""".stripMargin).execute()
        con.commit()
        Success
      }
    }(executionContext)
  }

  override def registerSelfSql: String = {
    """
      |INSERT INTO cluster_members(protocol, `system`, host, port, ttl)
      |VALUES (?, ?, ?, ?, CURRENT_TIMESTAMP + INTERVAL ? SECOND )""".stripMargin
  }


  override def listActiveSeedsSql: String = {
    """
      |SELECT host, port, ttl
      |FROM cluster_members
      |WHERE protocol = ? AND `system` = ? AND ttl > CURRENT_TIMESTAMP ORDER BY ttl""".stripMargin
  }

  override def heartbeatSql: String = {
    "UPDATE cluster_members SET ttl = (CURRENT_TIMESTAMP + INTERVAL ? SECOND) WHERE host = ? and port = ?"
  }

}
