package com.xebialabs.license;

import java.util.Arrays;
import java.util.List;

import static com.xebialabs.license.LicenseProperty.*;

public class MarketplaceLicense extends License {
    public MarketplaceLicense(LicensePropertyMap values) throws LicenseViolationException {
        super(values);
    }

    @Override
    public List<LicenseProperty> getLicenseProperties() {
        return Arrays.asList(LICENSE_VERSION, PRODUCT, EDITION, AWS_NONCE, AWS_PRODUCT_CODE, MAX_NUMBER_OF_CIS, MAX_NUMBER_OF_USERS, SUPPORT_POLICY);
    }

    @Override
    public List<LicenseProperty> getRequiredProperties() {
        return Arrays.asList(LICENSE_VERSION, PRODUCT, EDITION, AWS_NONCE, AWS_PRODUCT_CODE, SUPPORT_POLICY);
    }

    @Override
    public LicenseType getLicenseVersion() {
        return LicenseType.MARKETPLACE;
    }
}
