package com.xebialabs.license;

import java.util.HashMap;
import java.util.Map;

import static com.xebialabs.license.LicensePropertyType.DATE;
import static com.xebialabs.license.LicensePropertyType.LIST_OF_STRINGS;
import static com.xebialabs.license.LicensePropertyType.MAP_STRING_INTEGER;
import static com.xebialabs.license.LicensePropertyType.STRING;

/**
 * Property names used in license file
 */
public enum LicenseProperty {
    LICENSE_VERSION("License version", STRING),
    LICENSED_TO("Licensed to", STRING),
    CONTACT("Contact", STRING),
    PRODUCT("Product", STRING),
    EXPIRES_AFTER("Expires after", DATE),
    REPOSITORY_ID("Repository id", STRING),
    MAX_NUMBER_OF_USERS("Maximum number of users", STRING),
    MAX_NUMBER_OF_CIS("Licensed number of CIs", MAP_STRING_INTEGER),
    LICENSED_PLUGINS("Licensed plugin", LIST_OF_STRINGS),
    SUPPORT_POLICY("Support policy", STRING),
    EDITION("Edition", STRING);

    private static Map<String, LicenseProperty> lookup = new HashMap<>();
    static {
        for (LicenseProperty e : LicenseProperty.values()) {
            lookup.put(e.getName(), e);
        }
    }

    private final String name;
    private final LicensePropertyType type;

    LicenseProperty(String name, final LicensePropertyType type) {
        this.name = name;
        this.type = type;
    }

    public static LicenseProperty get(String name) {
        return lookup.get(name);
    }

    public static int getLongerNameLength() {
        int maxLength = 0;
        for (LicenseProperty licenseProperty : LicenseProperty.values()) {
            int length = licenseProperty.getName().length();
            if (length > maxLength) {
                maxLength = length;
            }
        }
        return maxLength;
    }

    public String getName() {
        return this.name;
    }

    public LicensePropertyType getType() {
        return type;
    }
}
