package com.xebialabs.deployit.local.message

import org.springframework.context.annotation.{Bean, Configuration}
import org.springframework.context.i18n.LocaleContextHolder
import org.springframework.context.support.ResourceBundleMessageSource

@Configuration
class LocalisationConfiguration {

  @Bean
  def deployMessageService(): MessageService = {
    MessageHolder.getMessageService(ProductName.DEPLOY)
  }

  @Bean
  def releaseMessageService(): MessageService = {
    MessageHolder.getMessageService(ProductName.RELEASE)
  }
}

object MessageHolder {

  def getMessageService(productName: ProductName): MessageService = {
    val source = new ResourceBundleMessageSource
    source.setBasenames(s"messages/${productName.toString.toLowerCase()}_messages")
    source.setUseCodeAsDefaultMessage(true)

    new MessageService() {
      override def getMessage(key: String, args: Object*): String = source.getMessage(key, args.toArray, LocaleContextHolder.getLocale)
      override def getMessage(key: String): String = getMessage(key, Array())
    }
  }
}

object DeployMessageHolder {
  def getMessage(key: String, args: Object*): String = MessageHolder.getMessageService(ProductName.DEPLOY).getMessage(key, args)
}

object ReleaseMessageHolder {
  def getMessage(key: String, args: Object*): String = MessageHolder.getMessageService(ProductName.RELEASE).getMessage(key, args)
}
