package com.xebialabs.analytics.pendo

import grizzled.slf4j.Logging

import java.util.concurrent.ConcurrentLinkedQueue

class PendoEventQueue(maxQueueSize: Int) extends Logging {

  val queue: ConcurrentLinkedQueue[PendoEvent] = new ConcurrentLinkedQueue

  def peek(): Option[PendoEvent] = Option(queue.peek())

  def poll(): PendoEvent = queue.poll()

  def add(eventData: PendoEvent): Unit = {
    if (queue.size() < maxQueueSize) {
      queue.add(eventData)
    } else {
      logger.warn(s"Not queuing Pendo tracked event ${eventData.eventType} due to max queue size reached")
    }
  }

  def size: Int = queue.size()

  def clear(): Unit = queue.clear()

}
