package com.xebialabs.plugin.manager.metadata

import akka.http.scaladsl.marshallers.sprayjson.SprayJsonSupport
import spray.json._


case class Requirements(product: XLProduct, versions: Set[VersionExpr])

object Requirements {
  trait Protocol extends SprayJsonSupport with DefaultJsonProtocol
    with XLProduct.Protocol
    with VersionExpr.Protocol {

    val requirementsWriter: JsonWriter[Requirements] = jsonWriter[Requirements] {
      case Requirements(product, versions) => JsObject(
        "product" -> product.toJson,
        "versions" -> versions.toJson
      )
    }
    val requirementsReader: JsonReader[Requirements] = jsonReader[Requirements] {
      case obj: JsObject =>
        obj.getFields("product", "versions") match {
          case Seq(product, JsArray(versions)) =>
            Requirements(product.convertTo[XLProduct], versions.map(_.convertTo[VersionExpr]).toSet)
          case other =>
            deserializationError(s"Cannot parse requirement: '$other'")
        }
      case unknown =>
        deserializationError(s"Cannot parse requirement: '$unknown'")
    }
    implicit val requirementsFormat: JsonFormat[Requirements] = jsonFormat(requirementsReader, requirementsWriter)
  }
}
