package com.xebialabs.plugin.manager.rest.json

import com.xebialabs.plugin.manager.rest.api.PluginManagerProtocol
import com.xebialabs.plugin.manager.rest.dto.RepositoryDto
import org.springframework.stereotype.Component
import spray.json._

import java.io.{IOException, OutputStream, OutputStreamWriter}
import java.lang.annotation.Annotation
import java.lang.reflect.Type
import jakarta.ws.rs.core.{MediaType, MultivaluedMap}
import jakarta.ws.rs.ext.{MessageBodyWriter, Provider}
import jakarta.ws.rs.{Produces, WebApplicationException}

@Component
@Provider
@Produces(Array(MediaType.APPLICATION_JSON))
class RepositoryDtoJsonWriter extends MessageBodyWriter[RepositoryDto] with PluginManagerProtocol
 {

  override def isWriteable(`type`: Class[_], genericType: Type, annotations: Array[Annotation],
                           mediaType: MediaType): Boolean = classOf[RepositoryDto].isAssignableFrom(`type`)

  override def getSize(viewList: RepositoryDto, `type`: Class[_], genericType: Type, annotations: Array[Annotation],
                       mediaType: MediaType): Long = -1

  @throws[IOException]
  @throws[WebApplicationException]
  override def writeTo(dto: RepositoryDto, `type`: Class[_], genericType: Type, annotations: Array[Annotation],
                       mediaType: MediaType, httpHeaders: MultivaluedMap[String, AnyRef],
                       entityStream: OutputStream): Unit = {

    val writer = new OutputStreamWriter(entityStream)
    writer.write(dto.repositories.toJson.compactPrint)
    writer.flush()
  }

}
