/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.plugin.manager.rest.api;

import com.xebialabs.xlplatform.documentation.PublicApi;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;

@Path(value="/{url:plugin-manager|api/v1/plugin-manager}")
@Produces(value={"application/json"})
@PublicApi
public interface PluginResource {
    @GET
    @Path(value="list")
    @Produces(value={"application/json"})
    public Response list();

    @GET
    @Path(value="repositories")
    @Produces(value={"application/json"})
    public Response listRepositories();

    @GET
    @Path(value="repositories/{repositoryId}/list")
    @Produces(value={"application/json"})
    public Response listRepository(@PathParam(value="repositoryId") String var1);

    @POST
    @Path(value="repositories/{repositoryId}/install-or-update/{groupId}/{artifactId}/{version}")
    @Produces(value={"application/json"})
    @Deprecated
    public Response installOrUpdateFromRepository(@PathParam(value="repositoryId") String var1, @PathParam(value="groupId") String var2, @PathParam(value="artifactId") String var3, @PathParam(value="version") String var4);

    @POST
    @Path(value="repositories/{repositoryId}/install/{groupId}/{artifactId}/{version}")
    @Produces(value={"application/json"})
    @Deprecated(since="23.3.0")
    public Response installFromRepository(@PathParam(value="repositoryId") String var1, @PathParam(value="groupId") String var2, @PathParam(value="artifactId") String var3, @PathParam(value="version") String var4);

    @POST
    @Path(value="repositories/{repositoryId}/install/{groupId}/{artifactId}/{version}/{packaging}")
    @Produces(value={"application/json"})
    public Response installFromRepository(@PathParam(value="repositoryId") String var1, @PathParam(value="groupId") String var2, @PathParam(value="artifactId") String var3, @PathParam(value="version") String var4, @PathParam(value="packaging") String var5);

    @POST
    @Path(value="repositories/{repositoryId}/update/{groupId}/{artifactId}")
    @Produces(value={"application/json"})
    @Deprecated(since="23.3.0")
    public Response updateFromRepository(@PathParam(value="repositoryId") String var1, @PathParam(value="groupId") String var2, @PathParam(value="artifactId") String var3);

    @POST
    @Path(value="repositories/{repositoryId}/update/{groupId}/{artifactId}/{packaging}")
    @Produces(value={"application/json"})
    public Response updateFromRepository(@PathParam(value="repositoryId") String var1, @PathParam(value="groupId") String var2, @PathParam(value="artifactId") String var3, @PathParam(value="packaging") String var4);

    @POST
    @Path(value="install-or-update")
    @Consumes(value={"multipart/form-data"})
    @Deprecated
    public Response installOrUpdate(MultipartFormDataInput var1, @QueryParam(value="pluginId") String var2);

    @POST
    @Path(value="install")
    @Consumes(value={"multipart/form-data"})
    public Response install(MultipartFormDataInput var1, @QueryParam(value="pluginId") String var2);

    @POST
    @Path(value="update")
    @Consumes(value={"multipart/form-data"})
    public Response update(MultipartFormDataInput var1, @QueryParam(value="existingPluginName") String var2, @QueryParam(value="newPluginId") String var3);

    @DELETE
    @Path(value="/delete/{repositoryId}/{groupId}/{artifactId}{version:(/.*)?}")
    public Response uninstall(@PathParam(value="repositoryId") String var1, @PathParam(value="groupId") String var2, @PathParam(value="artifactId") String var3, @PathParam(value="version") String var4);

    @GET
    @Path(value="search/{query}")
    @Produces(value={"application/json"})
    public Response search(@PathParam(value="query") String var1);

    @POST
    @Path(value="repositories/{repositoryId}/update")
    public Response updateRepository(@PathParam(value="repositoryId") String var1);

    @GET
    @Path(value="repositories/{repositoryId}/logo/{groupId}/{artifactId}")
    @Produces(value={"image/*"})
    public Response getLogo(@PathParam(value="repositoryId") String var1, @PathParam(value="groupId") String var2, @PathParam(value="artifactId") String var3);
}

