package com.xebialabs.plugin

package object manager {
  def requireProperFilename(s: String, fieldName: String): Unit = {
    require(Option(s).nonEmpty, s"$fieldName cannot be null")
    require(s.nonEmpty, s"$fieldName cannot be empty")
    require(!s.contains(":"), s"$fieldName cannot contain ':'")
    require(!s.contains(" ") && !s.contains('\t'), s"$fieldName cannot contain spaces")
    require(!s.contains('\n') && !s.contains('\r'), s"$fieldName cannot contain new lines")
    require(!s.contains('/') && !s.contains('\\'), s"$fieldName cannot contain '/' or '\\'")
  }

  def require(requirement: Boolean, message: => Any): Unit = {
    if (!requirement)
      throw new IllegalArgumentException(message.toString)
  }

  def require(requirement: Boolean): Unit = {
    if (!requirement)
      throw new IllegalArgumentException()
  }

}
