package com.xebialabs.plugin.manager.repository.sql

import com.xebialabs.plugin.manager.repository.sql.MigrationsSchema.{XLPM_PLUGIN, XLPM_PLUGIN_BYTES}

trait PluginQueries {

  val SELECT: String =
    s"""SELECT ${XLPM_PLUGIN.id}, ${XLPM_PLUGIN.name}, ${XLPM_PLUGIN.version}, ${XLPM_PLUGIN.extension},
       | ${XLPM_PLUGIN.groupId}, ${XLPM_PLUGIN.installationStatus}, ${XLPM_PLUGIN.source}, ${XLPM_PLUGIN.checksum},
       | ${XLPM_PLUGIN.pluginBytesId}
       | FROM ${XLPM_PLUGIN.TABLE}""".stripMargin

  val SELECT_WITH_BYTES: String =
    s"""SELECT ${XLPM_PLUGIN.TABLE}.${XLPM_PLUGIN.id}, ${XLPM_PLUGIN.name}, ${XLPM_PLUGIN.version},
        ${XLPM_PLUGIN.extension}, ${XLPM_PLUGIN.groupId}, ${XLPM_PLUGIN.installationStatus}, ${XLPM_PLUGIN.source},
        ${XLPM_PLUGIN.checksum} , ${XLPM_PLUGIN.pluginBytesId}, ${XLPM_PLUGIN_BYTES.bytes}
        FROM ${XLPM_PLUGIN.TABLE}, ${XLPM_PLUGIN_BYTES.TABLE}
        WHERE ${XLPM_PLUGIN.TABLE}.${XLPM_PLUGIN.pluginBytesId} = ${XLPM_PLUGIN_BYTES.TABLE}.${XLPM_PLUGIN_BYTES.id}"""

  val SELECT_BY_NAME: String = SELECT_WITH_BYTES + s""" AND ${XLPM_PLUGIN.name} = :NAME"""

  val SELECT_BY_NAME_AND_VERSION: String = SELECT_WITH_BYTES +
    s""" AND ${XLPM_PLUGIN.name} = :NAME
       | AND ${XLPM_PLUGIN.version} = :VERSION
       |""".stripMargin

  val INSERT_PLUGIN_BYTES: String =
    s"""INSERT INTO ${XLPM_PLUGIN_BYTES.TABLE} (${XLPM_PLUGIN_BYTES.id}, ${XLPM_PLUGIN_BYTES.bytes}) VALUES (:ID, :BYTES)"""

  val INSERT_PLUGIN: String =
    s"""INSERT INTO ${XLPM_PLUGIN.TABLE} (${XLPM_PLUGIN.id}, ${XLPM_PLUGIN.name}, ${XLPM_PLUGIN.version}, ${XLPM_PLUGIN.extension},
        ${XLPM_PLUGIN.groupId}, ${XLPM_PLUGIN.installationStatus}, ${XLPM_PLUGIN.source}, ${XLPM_PLUGIN.checksum},
        ${XLPM_PLUGIN.pluginBytesId}) VALUES (:ID, :NAME, :VERSION, :EXTENSION, :GROUP_ID, :INSTALLATION_STATUS, :SOURCE,
        :CHECKSUM, :PLUGIN_BYTES_ID)"""

  val UPDATE_PLUGIN_BYTES: String =
    s"""UPDATE ${XLPM_PLUGIN_BYTES.TABLE} SET ${XLPM_PLUGIN_BYTES.bytes} = :BYTES WHERE ${XLPM_PLUGIN_BYTES.id} = :ID"""

  val UPDATE_PLUGIN: String =
    s"""UPDATE ${XLPM_PLUGIN.TABLE} SET ${XLPM_PLUGIN.version} = :VERSION, ${XLPM_PLUGIN.groupId} = :GROUP_ID,
       ${XLPM_PLUGIN.installationStatus} = :INSTALLATION_STATUS, ${XLPM_PLUGIN.source} = :SOURCE,
       ${XLPM_PLUGIN.checksum} = :CHECKSUM
       WHERE ${XLPM_PLUGIN.id} = :ID"""

  val UPDATE_ALL_PLUGINS_STATUS =
    s"""UPDATE ${XLPM_PLUGIN.TABLE} SET ${XLPM_PLUGIN.installationStatus} = :STATUS"""

  val DELETE_PLUGIN_BYTES: String =
    s"""DELETE FROM ${XLPM_PLUGIN_BYTES.TABLE} WHERE ${XLPM_PLUGIN_BYTES.id} = :ID"""

  val DELETE_PLUGIN: String =
    s"""DELETE FROM ${XLPM_PLUGIN.TABLE} WHERE ${XLPM_PLUGIN.id} = :ID"""

  val SELECT_BY_REPO_GROUPID_ARTIFACTID_STATUS: String = SELECT +
    s""" WHERE ${XLPM_PLUGIN.source} = :SOURCE AND ${XLPM_PLUGIN.groupId} = :GROUP_ID AND ${XLPM_PLUGIN.name} = :NAME"""

  val SELECT_BY_REPO_GROUPID_ARTIFACTID_VERSION_STATUS: String =
    SELECT_BY_REPO_GROUPID_ARTIFACTID_STATUS + s""" AND ${XLPM_PLUGIN.version} = :VERSION"""

  val UPDATE_PLUGIN_STATUS =
    s"""UPDATE ${XLPM_PLUGIN.TABLE}
       | SET ${XLPM_PLUGIN.installationStatus} = :${XLPM_PLUGIN.installationStatus}
       | WHERE ${XLPM_PLUGIN.name} = :${XLPM_PLUGIN.name}""".stripMargin
}
