package com.xebialabs.plugin.manager.service

import com.xebialabs.plugin.manager.PluginId
import com.xebialabs.plugin.manager.metadata.{ArtifactId, PluginMetadata}
import com.xebialabs.plugin.manager.repository.PluginsRepository

object UpdateStrategy {

  def areSameVersions(installed: PluginId, available: ArtifactId): Boolean = installed.toArtifactId.version.equals(available.version)

  def doUpdate(repo: PluginsRepository,
               installedPlugins: Seq[PluginId],
               availablePlugins: Map[ArtifactId, Option[PluginMetadata]],
               pluginName: String,
               doUpdate: (PluginsRepository, PluginId.Artifact, PluginId) => InstallationResult): InstallationResult = {
    (installedPlugins, availablePlugins) match {
      case (installed, _) if installed.size > 1 => MultipleInstalledPluginsFoundForUpdate(pluginName)
      case (installed, _) if installed.isEmpty => ZeroInstalledPluginsFoundForUpdate(pluginName)
      case (_, available) if available.size > 1 => MultipleAvailablePluginsFoundForUpdate(pluginName, repo.name)
      case (_, available) if available.isEmpty => ZeroAvailablePluginsFoundForUpdate(pluginName, repo.name)
      case (installed, available) if installed.size == 1 && available.size == 1 && areSameVersions(installed.head, available.head._1) => PluginAlreadyAtLatestVersion(pluginName)
      case (installed, available) if installed.size == 1 && available.size == 1 =>
        doUpdate(repo, availablePlugins.head._1.toArtifact, installed.head.pluginId)
    }
  }

}
