/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.plugin.manager.repository.nexus;

import com.xebialabs.plugin.manager.config.Credentials;
import com.xebialabs.plugin.manager.config.Proxy;
import com.xebialabs.plugin.manager.config.Server;
import com.xebialabs.plugin.manager.repository.nexus.NexusServerConfig;
import java.io.Serializable;
import java.net.InetSocketAddress;
import org.apache.pekko.http.scaladsl.ClientTransport;
import org.apache.pekko.http.scaladsl.ClientTransport$;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.model.headers.BasicHttpCredentials;
import org.apache.pekko.http.scaladsl.model.headers.HttpCredentials;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class NexusServerConfig$
implements Serializable {
    public static final NexusServerConfig$ MODULE$ = new NexusServerConfig$();

    public ClientTransport $lessinit$greater$default$3() {
        return ClientTransport$.MODULE$.TCP();
    }

    public NexusServerConfig apply(Uri uri, HttpCredentials credentials, Uri proxyUri, Option<HttpCredentials> proxyCredentialsOpt) {
        ClientTransport clientTransport;
        InetSocketAddress proxyAddress = new InetSocketAddress(proxyUri.authority().host().address(), proxyUri.authority().port());
        Option<HttpCredentials> option = proxyCredentialsOpt;
        if (None$.MODULE$.equals(option)) {
            clientTransport = ClientTransport$.MODULE$.httpsProxy(proxyAddress);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            HttpCredentials proxyCredentials = (HttpCredentials)some.value();
            clientTransport = ClientTransport$.MODULE$.httpsProxy(proxyAddress, proxyCredentials);
        } else {
            throw new MatchError(option);
        }
        ClientTransport transport = clientTransport;
        return new NexusServerConfig(uri, credentials, transport);
    }

    public ClientTransport apply$default$3() {
        return ClientTransport$.MODULE$.TCP();
    }

    public Try<NexusServerConfig> fromConfig(Server serverConfig) {
        if (!"nexus".equals(serverConfig.getServerType())) {
            return new Failure((Throwable)new IllegalArgumentException("Plugin server " + serverConfig.getName() + " must have a 'nexus' server type"));
        }
        if (serverConfig.getUrl() == null || Try$.MODULE$.apply((Function0 & Serializable)() -> Uri$.MODULE$.apply(serverConfig.getUrl())).isFailure()) {
            return new Failure((Throwable)new IllegalArgumentException("Invalid url for plugin server " + serverConfig.getName()));
        }
        Credentials credentials = serverConfig.getCredentials();
        if (credentials == null || credentials.getPassword() == null || credentials.getUsername() == null) {
            return new Failure((Throwable)new IllegalArgumentException("Both username and password must be present in the '" + serverConfig.getName() + "' plugin server configuration"));
        }
        if (serverConfig.getProxy() != null && !this.isValid(serverConfig.getProxy())) {
            return new Failure((Throwable)new IllegalArgumentException("Invalid proxy configured for plugin server '" + serverConfig.getName() + "''"));
        }
        BasicHttpCredentials httpCredentials = new BasicHttpCredentials(credentials.getUsername(), credentials.getPassword());
        Uri uri = Uri$.MODULE$.apply(serverConfig.getUrl());
        Option<ClientTransport> option = this.getProxyTransport(serverConfig);
        if (option instanceof Some) {
            Some some = (Some)option;
            ClientTransport proxy = (ClientTransport)some.value();
            return new Success((Object)new NexusServerConfig(uri, (HttpCredentials)httpCredentials, proxy));
        }
        if (None$.MODULE$.equals(option)) {
            return new Success((Object)new NexusServerConfig(uri, (HttpCredentials)httpCredentials, this.$lessinit$greater$default$3()));
        }
        throw new MatchError(option);
    }

    public Option<ClientTransport> getProxyTransport(Server serverConfig) {
        if (serverConfig.getProxy() != null) {
            Proxy proxy = serverConfig.getProxy();
            InetSocketAddress address = new InetSocketAddress(proxy.getHost(), Predef$.MODULE$.Integer2int(proxy.getPort()));
            if (proxy.getCredentials() != null && this.hasValidCredentials(proxy.getCredentials())) {
                Credentials credentials = serverConfig.getProxy().getCredentials();
                return new Some((Object)ClientTransport$.MODULE$.httpsProxy(address, (HttpCredentials)new BasicHttpCredentials(credentials.getUsername(), credentials.getPassword())));
            }
            return new Some((Object)ClientTransport$.MODULE$.httpsProxy(address));
        }
        return None$.MODULE$;
    }

    public boolean isValid(Proxy proxy) {
        boolean validCredentials = proxy.getCredentials() == null || proxy.getCredentials().getUsername() != null && proxy.getCredentials().getPassword() != null;
        boolean validAddress = proxy.getHost() != null && proxy.getPort() != null;
        return validCredentials && validAddress;
    }

    public boolean hasValidCredentials(Credentials credentials) {
        return credentials.getPassword() != null && credentials.getUsername() != null;
    }

    public NexusServerConfig apply(Uri uri, HttpCredentials credentials, ClientTransport transport) {
        return new NexusServerConfig(uri, credentials, transport);
    }

    public Option<Tuple3<Uri, HttpCredentials, ClientTransport>> unapply(NexusServerConfig x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)x$0.uri(), (Object)x$0.credentials(), (Object)x$0.transport()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NexusServerConfig$.class);
    }

    private NexusServerConfig$() {
    }
}

