package com.xebialabs.deployit.service.externalproperties.validation

import com.xebialabs.deployit.service.externalproperties.ExternalValueProvider
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.annotation.{Bean, Configuration}

@Configuration
class ExternalPropertiesValidatorConfiguration {

  @Bean
  def lookupValueKeyValidator(@Autowired(required = false) providers: Array[ExternalValueProvider]): LookupValueKeyValidator = {
    new LookupValueKeyValidator(providers)
  }

  @Bean
  def externalPropertiesValidatorChain(lookupValueKeyValidator: LookupValueKeyValidator): ExternalPropertiesValidatorChain = {
    new ExternalPropertiesValidatorChain(List(lookupValueKeyValidator))
  }
}
