package com.xebialabs.deployit.repository

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.{Application, ConfigurationItem}

import scala.annotation.{tailrec, varargs}

object CiRepositoryUtils {
  private def existsByName(ciName: String, `type`: Type) = {
    val parameters = new SearchParameters().setType(`type`).setName(ciName).setExactNameSearch(true)
    !RepositoryServiceHolder.getRepositoryService.list(parameters).isEmpty
  }

  def checkApplicationOnUniquenessByName(ciName: String, `type`: Type): Unit = {
    val applicationType = Type.valueOf(classOf[Application])
    if (applicationType.instanceOf(`type`) && existsByName(ciName, `type`)) {
      throw new ItemAlreadyExistsException("Application with name [%s] already exists", ciName)
    }
  }

  @tailrec
  def findUniqueName(`type`: Type, baseName: String, suffix: String): String = {
    val name = baseName + " " + suffix
    if (existsByName(name, `type`)) findUniqueName(`type`, name, suffix)
    else name
  }

  @varargs
  def checkApplicationOnUniqueness(cis: ConfigurationItem*): Unit =
    cis.foreach(ci => checkApplicationOnUniquenessByName(ci.getName, ci.getType))
}
