package com.xebialabs.deployit;

import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlplatform.repository.XlRepositoryConfig;

public abstract class XlpRepositoryConfig implements XlRepositoryConfig {

    private String repositoryName;
    private String repositoryId = null;

    public XlpRepositoryConfig(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    @Override
    public String repositoryName() {
        return repositoryName;
    }

    @Override
    public Version repositoryVersion() {
        return Version.valueOf(repositoryName, ReleaseInfo.getReleaseInfo().getVersion());
    }

    @Override
    public String repositoryId() {
        return repositoryId;
    }

}
