package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.plugin.api.reflect.Type;

import java.util.Calendar;
import java.util.Map;
import java.util.Set;

/**
 * Declarative query parameters for searching the JCR repository for Configuration Items.
 */
public class SearchParameters extends com.xebialabs.deployit.plugin.api.services.SearchParameters {

    public SearchParameters() {
    }

    public SearchParameters(com.xebialabs.deployit.plugin.api.services.SearchParameters params) {
        setType(params.getType());
        setParent(params.getParent());
        setAncestor(params.getAncestor());
        setName(params.getName());
        setBefore(params.getBefore());
        setAfter(params.getAfter());
        setPage(params.getPage());
        setResultsPerPage(params.getResultsPerPage());
        setDepth(params.getDepth());

        for (Map.Entry<String,String> e : params.getProperties().entrySet()) {
            addProperty(e.getKey(), e.getValue());
        }
        for (Map.Entry<String, String> e : params.getTextSearchQueries().entrySet()) {
            addTextSearch(e.getKey(), e.getValue());
        }
        for (Map.Entry<String, Set<String>> e : params.getOrPropertiesExpression().entrySet()) {
            addOrPropertiesExpression(e.getKey(), e.getValue());
        }
    }

    @Override
    public SearchParameters setType(Type type) {
        super.setType(type);
        return this;
    }

    @Override
    public SearchParameters addProperty(String property, String value) {
        super.addProperty(property, value);
        return this;
    }

    @Override
    public SearchParameters addOrPropertiesExpression(final String property, final Set<String> values) {
        super.addOrPropertiesExpression(property, values);
        return this;
    }

    @Override
    public SearchParameters addTextSearch(String property, String searchQuery) {
        super.addTextSearch(property, searchQuery);
        return this;
    }

    @Override
    public SearchParameters setParent(String parent) {
        super.setParent(parent);
        return this;
    }

    @Override
    public SearchParameters setAncestor(String ancestor) {
        super.setAncestor(ancestor);
        return this;
    }

    @Override
    public SearchParameters setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public void setBefore(Calendar before) {
        super.setBefore(before);
    }

    @Override
    public void setAfter(Calendar after) {
        super.setAfter(after);
    }

    @Override
    public SearchParameters setPage(long page) {
        super.setPage(page);
        return this;
    }

    @Override
    public SearchParameters setResultsPerPage(long nrOfResults) {
        super.setResultsPerPage(nrOfResults);
        return this;
    }

    @Override
    public SearchParameters setDepth(int depth) {
        super.setDepth(depth);
        return this;
    }

    @Override
    public SearchParameters setExactNameSearch(boolean isExactNameSearch) {
        super.setExactNameSearch(isExactNameSearch);
        return this;
    }

}
