package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.util.Tuple;

import java.util.ArrayList;
import java.util.List;

import static com.xebialabs.deployit.util.Tuple.of;

public class ChangeSet {

    private List<ConfigurationItem> createCis = new ArrayList<>();
    private List<ConfigurationItem> updateCis = new ArrayList<>();
    private List<String> deleteCiIds = new ArrayList<>();
    private List<ConfigurationItem> createOrUpdateCis = new ArrayList<>();
    private List<Tuple<String, String>> renameCis = new ArrayList<>();
    private List<Tuple<String, String>> moveCis = new ArrayList<>();
    private List<Tuple<String, String>> copyCis = new ArrayList<>();
    private boolean disableVersionHistory = false;
    private List<ConfigurationItem> createOrUpdateActualUpdatedCis = new ArrayList<>();
    private List<ConfigurationItem> createOrUpdateActualCreatedCis = new ArrayList<>();

    public void create(ConfigurationItem ci) {
        this.createCis.add(ci);
    }

    public void create(List<? extends ConfigurationItem> entities) {
        this.createCis.addAll(entities);
    }

    public void update(ConfigurationItem ci) {
        this.updateCis.add(ci);
    }

    public void update(List<? extends ConfigurationItem> entities) {
        this.updateCis.addAll(entities);
    }

    public void createOrUpdate(ConfigurationItem entity) {
        this.createOrUpdateCis.add(entity);
    }

    public void createOrUpdate(List<? extends ConfigurationItem> entities) {
        this.createOrUpdateCis.addAll(entities);
    }

    public void delete(ConfigurationItem ci) {
        this.deleteCiIds.add(ci.getId());
    }

    public void delete(String id) {
        this.deleteCiIds.add(id);
    }

    public void delete(List<? extends String> ids) {
        this.deleteCiIds.addAll(ids);
    }

    public void rename(String id, String newName) {
        this.renameCis.add(of(id, newName));
    }

    public void rename(ConfigurationItem ci, String newName) {
        this.renameCis.add(of(ci.getId(), newName));
    }

    public void move(String ci, String newId) {
        this.moveCis.add(of(ci, newId));
    }

    public void copy(String ci, String newId) {
        this.copyCis.add(of(ci, newId));
    }

    public void setDisableVersionHistory(boolean checkPointRequested) {
        this.disableVersionHistory = checkPointRequested;
    }

    public List<ConfigurationItem> getCreateCis() {
        return createCis;
    }

    public List<ConfigurationItem> getUpdateCis() {
        return updateCis;
    }

    public List<ConfigurationItem> getCreateOrUpdateCis() {
        return createOrUpdateCis;
    }

    public List<String> getDeleteCiIds() {
        return deleteCiIds;
    }

    public List<Tuple<String, String>> getRenameCis() {
        return renameCis;
    }

    public List<Tuple<String, String>> getMoveCis() {
        return moveCis;
    }

    public List<Tuple<String, String>> getCopyCis() {
        return copyCis;
    }

    public List<ConfigurationItem> getCreateOrUpdateActualUpdatedCis() {
        return createOrUpdateActualUpdatedCis;
    }

    public List<ConfigurationItem> getCreateOrUpdateActualCreatedCis() {
        return createOrUpdateActualCreatedCis;
    }

    public boolean isDisableVersionHistory() {
        return disableVersionHistory;
    }

}
