package com.xebialabs.xlplatform.repository

import java.io.InputStream

import com.typesafe.config.Config
import com.xebialabs.deployit.RepoCredentials
import com.xebialabs.deployit.server.api.upgrade.Version

trait XlRepositoryConfig {
  def repositoryName: String

  def repositoryVersion: Version

  def repositoryId: String

  def repositoryConfig: Config

  def credentials: RepoCredentials

}

class RepositoryConfigurationSource(resourceName: String) {
  def getInputStream(): InputStream = Thread.currentThread().getContextClassLoader.getResourceAsStream(resourceName)
  def getName(): String = resourceName
}