/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.telnet.term.console;

import java.io.IOException;
import org.crsh.telnet.term.spi.TermIO;

public class TermIOWriter {
    private boolean previousCR;
    private final TermIO io;

    public TermIOWriter(TermIO io) {
        this.io = io;
    }

    public void write(CharSequence s) throws IOException {
        int len = s.length();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                this.writeNoFlush(c);
            }
        }
    }

    public void write(char c) throws IOException {
        this.writeNoFlush(c);
    }

    private void writeNoFlush(char c) throws IOException {
        if (this.previousCR && c == '\n') {
            this.previousCR = false;
        } else if (c == '\r' || c == '\n') {
            this.previousCR = c == '\r';
            this.io.writeCRLF();
        } else {
            this.io.write(c);
        }
    }
}

