package com.xebialabs.xlplatform.repository.jackrabbit.crash.spring;


import javax.jcr.Repository;
import javax.naming.NamingException;
import org.eclipse.jetty.jndi.NamingUtil;
import org.springframework.jndi.JndiTemplate;

import static com.xebialabs.xlplatform.repository.jackrabbit.crash.spring.CrashConfiguration.JNDI_JACKRABBIT;

public class JcrRepoBinder {

    public JcrRepoBinder(JndiTemplate jndiTemplate, Repository repository) {
        try {
            NamingUtil.bind(jndiTemplate.getContext(), JNDI_JACKRABBIT, repository);
        } catch (NamingException e) {
            throw new IllegalStateException("Unable to bind JCR repository to JNDI entry.", e);
        }
    }
}
