/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.repository.jackrabbit.crash;

import com.xebialabs.deployit.jcr.JackrabbitRepositoryFactoryBean;
import com.xebialabs.deployit.jcr.jackrabbit.JackrabbitRepositoryConfigurationFactoryBean;
import com.xebialabs.deployit.jcr.jackrabbit.JackrabbitRepositoryInitializer;
import com.xebialabs.xlplatform.repository.XlRepositoryConfig;
import com.xebialabs.xlplatform.repository.jackrabbit.crash.XlJackrabbitPlugin;
import java.io.Console;
import java.util.logging.Level;
import java.util.logging.LogManager;
import javax.jcr.Repository;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.crsh.standalone.CRaSH;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class CrashTool
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CrashTool.class);
    private XlRepositoryConfig xlRepositoryConfig;

    public CrashTool(XlRepositoryConfig xlRepositoryConfig) {
        this.xlRepositoryConfig = xlRepositoryConfig;
    }

    private void displayWarning() {
        System.out.println("***   This will attempt to start only the JCR repository with CRaSH shell enabled.    ***");
        System.out.println("***      Changes that you save to the JCR repository may permanently corrupt it.      ***");
        System.out.println("***        It is HIGHLY recommended that you create a backup before you proceed.      ***");
        System.out.println("***                 Are you sure you want to continue?                                ***");
        Console console = System.console();
        if (console == null) {
            throw new IllegalStateException("Not running in interactive mode, please run crash from a console. Quitting now.");
        }
        String s = console.readLine("Please enter 'yes' if you wish to continue. [no] > ", new Object[0]);
        if (!s.equalsIgnoreCase("yes")) {
            System.exit(98);
        }
    }

    @Override
    public void run() {
        this.configureLogging();
        this.displayWarning();
        try {
            Repository repository = this.bootRepository();
            XlJackrabbitPlugin.setRepository(repository);
            CRaSH.main((String[])new String[0]);
        }
        catch (Exception e) {
            logger.error("Unable to start CRaSH", (Throwable)e);
        }
        finally {
            logger.info("Stopping standalone CRaSH JCR server");
        }
    }

    private Repository bootRepository() throws Exception {
        JackrabbitRepositoryConfigurationFactoryBean configurationFactoryBean = new JackrabbitRepositoryConfigurationFactoryBean(this.xlRepositoryConfig, false);
        RepositoryConfig repositoryConfig = configurationFactoryBean.getObject();
        JackrabbitRepositoryInitializer repositoryInitializer = new JackrabbitRepositoryInitializer(this.xlRepositoryConfig);
        JackrabbitRepositoryFactoryBean repositoryFactoryBean = new JackrabbitRepositoryFactoryBean(repositoryConfig, repositoryInitializer);
        return repositoryFactoryBean.getObject();
    }

    private void configureLogging() {
        LogManager.getLogManager().reset();
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        java.util.logging.Logger.getLogger("global").setLevel(Level.FINEST);
    }
}

