package com.xebialabs.xlplatform.repository.jackrabbit.crash.spring;


import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.jcr.Repository;
import org.crsh.spring.SpringBootstrap;
import org.crsh.telnet.TelnetPlugin;
import org.crsh.telnet.term.processor.ProcessorIOHandler;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

import com.xebialabs.xlplatform.repository.jackrabbit.crash.XlJackrabbitPlugin;

@Configuration
@ConditionalOnSystemProperty(CrashConfiguration.CRASH_ENABLED_PROPERTY)
public class CrashConfiguration {

    public static final String CRASH_ENABLED_PROPERTY = "com.xebialabs.crash";
    public static final String JNDI_JACKRABBIT =  "java:comp/env/jcr/jackrabbit";
    public static final String CRASH_TELNET_PORT = "5000";

    @Bean
    public SpringBootstrap crashBootstrap() {
        configureLogging();
        SpringBootstrap springBootstrap = new SpringBootstrap();
        final Properties props = new Properties();
        props.setProperty("crash.vfs.refresh_period", "1");
        props.setProperty("crash.telnet.port", CRASH_TELNET_PORT);

        springBootstrap.setConfig(props);
        return springBootstrap;
    }

    private void configureLogging() {
        LogManager.getLogManager().reset();
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        Logger.getLogger("global").setLevel(Level.FINEST);
    }

    @Autowired
    @Bean
    XlJackrabbitPlugin jackrabbitPlugin(Repository repository) {
        XlJackrabbitPlugin.setRepository(repository);
        return new XlJackrabbitPlugin();
    }

    @Bean
    TelnetPlugin telnetPlugin() {
        return new TelnetPlugin();
    }

    @Bean
    @DependsOn("telnetPlugin")
    ProcessorIOHandler processorIOHandler() {
        return new ProcessorIOHandler();
    }
}
