package com.xebialabs.xlplatform.repository.jackrabbit.crash.spring;

import java.util.Map;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class OnSystemPropertyCondition implements Condition {

    @Override
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Map<String, Object> attributes = metadata.getAnnotationAttributes(ConditionalOnSystemProperty.class.getName());
        Boolean systemPropertyExistsCheck = (Boolean) attributes.get("exists");
        String systemProperty = (String) attributes.get("value");

        return (systemPropertyExistsCheck && System.getProperty(systemProperty) != null) ||
                !systemPropertyExistsCheck && System.getProperty(systemProperty) == null;
    }
}