package com.xebialabs.xlplatform.artifact.resolution.jcr

import java.io.{IOException, InputStream}
import javax.jcr.Binary

private[jcr] class JcrDelegatingInputStream(binary: Binary) extends InputStream {

  private val wrapped: InputStream = binary.getStream

  @throws(classOf[IOException])
  def read: Int = wrapped.read

  @throws(classOf[IOException])
  override def read(b: Array[Byte]): Int = wrapped.read(b)

  @throws(classOf[IOException])
  override def read(b: Array[Byte], off: Int, len: Int): Int = wrapped.read(b, off, len)

  @throws(classOf[IOException])
  override def skip(n: Long): Long = wrapped.skip(n)

  @throws(classOf[IOException])
  override def available: Int = wrapped.available

  @throws(classOf[IOException])
  override def close {
    try {
      wrapped.close
    } finally {
      binary.dispose
    }
  }

  override def mark(readlimit: Int) = wrapped.mark(readlimit)

  @throws(classOf[IOException])
  override def reset = wrapped.reset

  override def markSupported: Boolean = wrapped.markSupported
}
