package com.xebialabs.xlplatform.repository

import java.io.InputStream
import javax.jcr.Credentials

import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot
import com.xebialabs.deployit.server.api.upgrade.Version

trait XlRepositoryConfig {
  def repositoryName: String

  def repositoryVersion: Version

  def repositoryId: Option[String]

  def jcrRepositoryConfig: RepositoryConfigurationSource

  def credentials: Option[_ <: Credentials]

}

class RepositoryConfigurationSource(resourceName: String) {
  def getInputStream(): InputStream = Thread.currentThread().getContextClassLoader.getResourceAsStream(resourceName)
  def getName(): String = resourceName
}