package com.xebialabs.deployit.jcr;

import com.google.common.base.Supplier;

/**
 * Implementation of the Supplier interface, that supplies a value from the JCR Repository.
 */
public class JcrSupplier<T> implements Supplier<T> {
    private final JcrCallback<T> callback;
    private final boolean newSession;

    public JcrSupplier(JcrCallback<T> callback) {
        this(callback, true);
    }

    public JcrSupplier(JcrCallback<T> callback, boolean newSession) {
        this.callback = callback;
        this.newSession = newSession;
    }

    @Override
    public T get() {
        return JcrTemplateHolder.get().execute(callback, newSession);
    }
}
