package com.xebialabs.deployit.repository

import java.util.{List => JList}

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.util.Tuple
import collection.convert.wrapAll._

class RepositoryUtils(val repositoryService: RepositoryService) {

  def readTree(copyCommands: JList[Tuple[String, String]]): Seq[Type] =
    copyCommands.flatMap  { t =>
      val id = t.getA
      val sp = new SearchParameters()
      sp.setAncestor(id)
      repositoryService.list(sp).map(_.getType) :+
        repositoryService.read(id).asInstanceOf[ConfigurationItem].getType
    }

}
