/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jcr;

import com.xebialabs.deployit.repository.BaseQueryTemplate;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrQueryTemplate
extends BaseQueryTemplate {
    private static final Logger logger = LoggerFactory.getLogger(JcrQueryTemplate.class);

    public JcrQueryTemplate(String query) {
        super(query);
    }

    public JcrQueryTemplate(String query, Map<String, Object> parameters) {
        super(query, parameters);
    }

    String getQueryString() {
        return this.queryString;
    }

    public Query createQuery(Session session) throws RepositoryException {
        QueryManager qm = session.getWorkspace().getQueryManager();
        Query query = qm.createQuery(this.queryString, "JCR-SQL2");
        this.addBindings(session.getValueFactory(), query);
        this.addPagingInfo(query);
        logger.trace("JCR query built: {}", (Object)query.getStatement());
        return query;
    }

    private void addBindings(ValueFactory valueFactory, Query query) throws RepositoryException {
        for (Map.Entry parameter : this.parameters.entrySet()) {
            query.bindValue((String)parameter.getKey(), JcrQueryTemplate.toValue(valueFactory, parameter.getValue()));
        }
    }

    void addPagingInfo(Query query) {
        if (this.resultsPerPage > 0L) {
            query.setLimit(this.resultsPerPage);
            query.setOffset(this.page * this.resultsPerPage);
        }
    }

    private static Value toValue(ValueFactory factory, Object valueObject) throws RepositoryException {
        if (valueObject instanceof String) {
            return factory.createValue((String)valueObject);
        }
        if (valueObject instanceof Calendar) {
            return factory.createValue((Calendar)valueObject);
        }
        if (valueObject instanceof BigDecimal) {
            return factory.createValue((BigDecimal)valueObject);
        }
        if (valueObject instanceof Binary) {
            return factory.createValue((Binary)valueObject);
        }
        if (valueObject instanceof Boolean) {
            return factory.createValue(((Boolean)valueObject).booleanValue());
        }
        if (valueObject instanceof Double) {
            return factory.createValue(((Double)valueObject).doubleValue());
        }
        if (valueObject instanceof Long) {
            return factory.createValue(((Long)valueObject).longValue());
        }
        if (valueObject instanceof Node) {
            return factory.createValue((Node)valueObject);
        }
        throw new IllegalArgumentException("Unsupported value type for JCR query: " + valueObject.getClass().getName());
    }

    public String toString() {
        return "JcrQueryTemplate [queryString=" + this.queryString + ", parameters=" + this.parameters + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", depth = " + this.depth + "]";
    }
}

