/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.repository;

import com.xebialabs.deployit.JcrCredentials;
import com.xebialabs.deployit.RepoCredentials;
import com.xebialabs.deployit.booter.local.CiRoots;
import com.xebialabs.deployit.jcr.JcrConstants;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.repository.internal.Root;
import com.xebialabs.xlplatform.repository.JcrRepositoryMetadataService;
import com.xebialabs.xlplatform.repository.XlRepositoryConfig;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.util.Calendar;
import javax.jcr.Credentials;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.convert.WrapAsScala;
import scala.collection.convert.package$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001B\u0001\u0003\u0001-\u0011!\u0004\u00177KGJ\u0014V\r]8tSR|'/_%oSRL\u0017\r\\5{KJT!a\u0001\u0003\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002\u0006\r\u0005Q\u0001\u0010\u001c9mCR4wN]7\u000b\u0005\u001dA\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005I\u0011aA2p[\u000e\u00011c\u0001\u0001\r%A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"a\u0005\r\u000e\u0003QQ!!\u0006\f\u0002\u000bMdg\r\u000e6\u000b\u0003]\t\u0001b\u001a:jujdW\rZ\u0005\u00033Q\u0011q\u0001T8hO&tw\r\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u001d\u0003IAHNU3q_NLGo\u001c:z\u0007>tg-[4\u0011\u0005uqR\"\u0001\u0002\n\u0005}\u0011!A\u0005-m%\u0016\u0004xn]5u_JL8i\u001c8gS\u001eDQ!\t\u0001\u0005\u0002\t\na\u0001P5oSRtDCA\u0012%!\ti\u0002\u0001C\u0003\u001cA\u0001\u0007A\u0004C\u0004'\u0001\t\u0007I\u0011A\u0014\u0002\u001d)\u001c'o\u0011:fI\u0016tG/[1mgV\t\u0001\u0006\u0005\u0002*]5\t!F\u0003\u0002,Y\u0005\u0019!n\u0019:\u000b\u00035\nQA[1wCbL!a\f\u0016\u0003\u0017\r\u0013X\rZ3oi&\fGn\u001d\u0005\u0007c\u0001\u0001\u000b\u0011\u0002\u0015\u0002\u001f)\u001c'o\u0011:fI\u0016tG/[1mg\u0002Bqa\r\u0001C\u0002\u0013\u0005A'\u0001\u0007sKB|7/\u001b;pefLE-F\u00016!\t1\u0014H\u0004\u0002\u000eo%\u0011\u0001HD\u0001\u0007!J,G-\u001a4\n\u0005iZ$AB*ue&twM\u0003\u00029\u001d!1Q\b\u0001Q\u0001\nU\nQB]3q_NLGo\u001c:z\u0013\u0012\u0004\u0003\"B \u0001\t\u0003\u0001\u0015\u0001B5oSR$\"!\u0011#\u0011\u00055\u0011\u0015BA\"\u000f\u0005\u0011)f.\u001b;\t\u000b\rq\u0004\u0019A#\u0011\u0005%2\u0015BA$+\u0005)\u0011V\r]8tSR|'/\u001f\u0005\u0007\u0013\u0002\u0001K\u0011\u0002&\u0002'%t\u0017\u000e^5bY&TXMT8eKRK\b/Z:\u0015\u0005\u0005[\u0005\"\u0002'I\u0001\bi\u0015aB:fgNLwN\u001c\t\u0003S9K!a\u0014\u0016\u0003\u000fM+7o]5p]\"1\u0011\u000b\u0001Q\u0005\nI\u000bA\u0002Z8J]&$\u0018.\u00197ju\u0016$\"aU+\u0015\u0005\u0005#\u0006\"\u0002'Q\u0001\bi\u0005\"B\u0002Q\u0001\u0004)\u0005BB,\u0001A\u0013%\u0001,A\u0007jg&s\u0017\u000e^5bY&TX\r\u001a\u000b\u00033r\u0003\"!\u0004.\n\u0005ms!a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u0019Z\u0003\r!\u0014\u0005\u0007=\u0002\u0001K\u0011B0\u0002\u001f\r\u0014X-\u0019;f\u001b&D\u0018N\u001c+za\u0016$\"\u0001\u00192\u0015\u0005\u0005\u000b\u0007\"\u0002'^\u0001\bi\u0005\"B2^\u0001\u0004)\u0014\u0001\u0003;za\u0016t\u0015-\\3\t\r\u0015\u0004\u0001\u0015\"\u0003g\u00031\u0019'/Z1uKbc'k\\8u)\t9\u0017\u000e\u0006\u0002BQ\")A\n\u001aa\u0002\u001b\")!\u000e\u001aa\u0001k\u0005A!o\\8u\u001d\u0006lW\r\u0003\u0004m\u0001\u0001&I!\\\u0001\u000bKbL7\u000f^:O_\u0012,GC\u00018q)\tIv\u000eC\u0003MW\u0002\u000fQ\nC\u0003rW\u0002\u0007Q'\u0001\u0005o_\u0012,g*Y7f\u0011\u0019\u0019\b\u0001)C\u0005i\u0006)2M]3bi\u0016tu\u000eZ3JM:{G/\u0012=jgR\u001cHCA;{)\t1\u0018\u0010\u0005\u0002\u000eo&\u0011\u0001P\u0004\u0002\u0004\u0003:L\b\"\u0002's\u0001\bi\u0005\"B9s\u0001\u0004)\u0004B\u0002?\u0001A\u0013%Q0\u0001\u0006de\u0016\fG/\u001a(pI\u0016$2A`A\u0004)\ry\u0018Q\u0001\t\u0004S\u0005\u0005\u0011bAA\u0002U\t!aj\u001c3f\u0011\u0015a5\u0010q\u0001N\u0011\u0015\t8\u00101\u00016\u0011!\tY\u0001\u0001Q\u0005\n\u00055\u0011\u0001E:u_J,'+\u001a9p-\u0016\u00148/[8o)\r\t\u0015q\u0002\u0005\u0007\u0019\u0006%\u00019A'\t\u0011\u0005M\u0001\u0001)C\u0005\u0003+\t\u0011c\u001d;pe\u0016\u0014V\r]8tSR|'/_%e)\r\t\u0015q\u0003\u0005\u0007\u0007\u0005E\u0001\u0019A#")
public class XlJcrRepositoryInitializer
implements Logging {
    private final Credentials jcrCredentials;
    private final String repositoryId;
    private final Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        XlJcrRepositoryInitializer xlJcrRepositoryInitializer = this;
        synchronized (xlJcrRepositoryInitializer) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.class.grizzled$slf4j$Logging$$_logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.grizzled$slf4j$Logging$$_logger;
        }
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger : this.grizzled$slf4j$Logging$$_logger$lzycompute();
    }

    public Logger logger() {
        return Logging.class.logger((Logging)this);
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.class.isErrorEnabled((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.class.isWarnEnabled((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, msg, t);
    }

    public Credentials jcrCredentials() {
        return this.jcrCredentials;
    }

    public String repositoryId() {
        return this.repositoryId;
    }

    /*
     * WARNING - void declaration
     */
    public void init(Repository repository) {
        Session session = repository.login(this.jcrCredentials());
        try {
            if (this.isInitialized(session)) {
                this.logger().info((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Nodetypes already initialized!";
                    }
                });
            } else {
                this.initializeNodeTypes(session);
            }
            this.doInitialize(repository, session);
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.logout();
            throw throwable;
        }
        session.logout();
    }

    private void initializeNodeTypes(Session session) {
        session.getWorkspace().getNamespaceRegistry().registerNamespace(JcrConstants.DEPLOYIT_NAMESPACE_PREFIX, JcrConstants.DEPLOYIT_NAMESPACE_URI);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{JcrConstants.CONFIGURATION_ITEM_NODETYPE_NAME, JcrConstants.ARTIFACT_NODETYPE_NAME, JcrConstants.TASK_NODETYPE_NAME, JcrConstants.STEP_NODETYPE_NAME, JcrConstants.CONFIGURATION_NODETYPE_NAME}))).foreach((Function1)new Serializable(this, session){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ XlJcrRepositoryInitializer $outer;
            private final Session session$2;

            public final void apply(String typeName) {
                this.$outer.com$xebialabs$xlplatform$repository$XlJcrRepositoryInitializer$$createMixinType(typeName, this.session$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.session$2 = session$2;
            }
        });
    }

    private void doInitialize(Repository repository, Session session) {
        Predef$.MODULE$.require(((WrapAsScala)package$.MODULE$.wrapAll()).asScalaSet(CiRoots.all()).nonEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "No ConfigurationItems Roots are found in type system";
            }
        });
        ((IterableLike)((WrapAsScala)package$.MODULE$.wrapAll()).asScalaSet(CiRoots.all()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).nonEmpty();
            }
        })).foreach((Function1)new Serializable(this, session){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ XlJcrRepositoryInitializer $outer;
            private final Session session$3;

            public final void apply(String rootName) {
                this.$outer.com$xebialabs$xlplatform$repository$XlJcrRepositoryInitializer$$createXlRoot(rootName, this.session$3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.session$3 = session$3;
            }
        });
        if (!this.existsNode(JcrConstants.CONFIGURATION_NODE_NAME, session)) {
            this.createNode(JcrConstants.CONFIGURATION_NODE_NAME, session).addMixin(JcrConstants.CONFIGURATION_NODETYPE_NAME);
        }
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{JcrConstants.TASKS_NODE_NAME, JcrConstants.SECURITY_NODE_NAME, JcrConstants.ROLES_NODE_NAME, JcrConstants.ROLE_ASSIGNMENTS_NODE_NAME}))).foreach((Function1)new Serializable(this, session){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ XlJcrRepositoryInitializer $outer;
            private final Session session$3;

            public final Object apply(String nodeName) {
                return this.$outer.com$xebialabs$xlplatform$repository$XlJcrRepositoryInitializer$$createNodeIfNotExists(nodeName, this.session$3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.session$3 = session$3;
            }
        });
        this.storeRepoVersion(session);
        session.save();
        this.storeRepositoryId(repository);
        session.save();
    }

    private boolean isInitialized(Session session) {
        return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable(this, session){
            public static final long serialVersionUID = 0L;
            private final Session session$1;

            public final String apply() {
                return this.session$1.getNamespaceURI(JcrConstants.DEPLOYIT_NAMESPACE_PREFIX);
            }
            {
                this.session$1 = session$1;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return true;
            }
        }).recover((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1 instanceof NamespaceException ? BoxesRunTime.boxToBoolean((boolean)false) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof NamespaceException;
                return bl;
            }
        }).get());
    }

    public void com$xebialabs$xlplatform$repository$XlJcrRepositoryInitializer$$createMixinType(String typeName, Session session) {
        NodeTypeManager manager = session.getWorkspace().getNodeTypeManager();
        NodeTypeTemplate nodeTypeTemplate = manager.createNodeTypeTemplate();
        nodeTypeTemplate.setName(typeName);
        nodeTypeTemplate.setQueryable(true);
        nodeTypeTemplate.setAbstract(false);
        nodeTypeTemplate.setMixin(true);
        NodeType nodeType = manager.registerNodeType((NodeTypeDefinition)nodeTypeTemplate, false);
        this.logger().debug((Function0)new Serializable(this, nodeType){
            public static final long serialVersionUID = 0L;
            private final NodeType nodeType$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registered NodeType definition: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.nodeType$1}));
            }
            {
                this.nodeType$1 = nodeType$1;
            }
        });
    }

    public void com$xebialabs$xlplatform$repository$XlJcrRepositoryInitializer$$createXlRoot(String rootName, Session session) {
        if (!this.existsNode(rootName, session)) {
            Node node = this.createNode(rootName, session);
            node.addMixin(JcrConstants.CONFIGURATION_ITEM_NODETYPE_NAME);
            node.addMixin("{http://www.jcp.org/jcr/mix/1.0}versionable");
            node.setProperty(JcrConstants.CONFIGURATION_ITEM_TYPE_PROPERTY_NAME, new StringBuilder().append((Object)"internal.").append((Object)Root.class.getSimpleName()).toString());
            node.setProperty(JcrConstants.LAST_MODIFIED_AT_PROPERTY_NAME, Calendar.getInstance());
            this.logger().debug((Function0)new Serializable(this, rootName, node){
                public static final long serialVersionUID = 0L;
                private final String rootName$1;
                private final Node node$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Configured XL Rootnode ", " at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rootName$1, this.node$1}));
                }
                {
                    this.rootName$1 = rootName$1;
                    this.node$1 = node$1;
                }
            });
        }
    }

    private boolean existsNode(String nodeName, Session session) {
        return session.getRootNode().hasNode(nodeName);
    }

    public Object com$xebialabs$xlplatform$repository$XlJcrRepositoryInitializer$$createNodeIfNotExists(String nodeName, Session session) {
        return this.existsNode(nodeName, session) ? BoxedUnit.UNIT : this.createNode(nodeName, session);
    }

    /*
     * WARNING - void declaration
     */
    private Node createNode(String nodeName, Session session) {
        void var3_3;
        Node node = session.getRootNode().addNode(nodeName);
        this.logger().debug((Function0)new Serializable(this, node){
            public static final long serialVersionUID = 0L;
            private final Node node$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Created node ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.node$2}));
            }
            {
                this.node$2 = node$2;
            }
        });
        return var3_3;
    }

    private void storeRepoVersion(Session session) {
        if (!this.existsNode(JcrConstants.VERSIONS_NODE_NAME, session)) {
            Node node = session.getRootNode().addNode(JcrConstants.VERSIONS_NODE_NAME);
            this.logger().debug((Function0)new Serializable(this, node){
                public static final long serialVersionUID = 0L;
                private final Node node$3;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initialized repository version node at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.node$3}));
                }
                {
                    this.node$3 = node$3;
                }
            });
        }
    }

    private void storeRepositoryId(Repository repository) {
        JcrTemplate template = new JcrTemplate(repository, this.jcrCredentials());
        JcrRepositoryMetadataService metadataService = new JcrRepositoryMetadataService(template);
        if (this.repositoryId() != null) {
            metadataService.validateAndStoreRepositoryId(this.repositoryId());
        }
    }

    public XlJcrRepositoryInitializer(XlRepositoryConfig xlRepositoryConfig) {
        Logging.class.$init$((Logging)this);
        RepoCredentials repoCredentials = xlRepositoryConfig.credentials();
        if (repoCredentials instanceof JcrCredentials) {
            Credentials creds;
            Credentials credentials;
            JcrCredentials jcrCredentials = (JcrCredentials)repoCredentials;
            this.jcrCredentials = credentials = (creds = jcrCredentials.creds());
            this.repositoryId = xlRepositoryConfig.repositoryId();
            return;
        }
        throw new IllegalStateException("Credentials must be of type JcrCredentials");
    }
}

