package com.xebialabs.deployit.jcr;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.concurrent.atomic.AtomicReference;

@Component
public class JcrTemplateHolder {

    private static final AtomicReference<JcrTemplate> TEMPLATE_HOLDER = new AtomicReference<JcrTemplate>();

    @Autowired
    public JcrTemplateHolder(JcrTemplate template) {
        JcrTemplateHolder.TEMPLATE_HOLDER.getAndSet(template);
    }

    public static JcrTemplate get() {
        return TEMPLATE_HOLDER.get();
    }
}
