package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.jcr.JcrQueryTemplate;
import com.xebialabs.deployit.server.api.upgrade.RepoType;

import java.util.Map;

public class JcrQueryTemplateFactory implements QueryTemplateFactory {

    @Override
    public RepoType getRepositoryType() {
        return RepoType.JCR;
    }

    @Override
    public QueryTemplate createTemplate(String query) {
        return new JcrQueryTemplate(query);
    }

    @Override
    public QueryTemplate createTemplate(String query, Map<String, Object> parameters) {
        return new JcrQueryTemplate(query, parameters);
    }
}
