package com.xebialabs.xlplatform.repository.jcrsql2

sealed trait JoinCondition {
  def build(): String
}
case class EquiJoinCondition(selector1: Selector, property1: String, selector2: Selector, property2: String) extends JoinCondition {
  override def build(): String = s"${selector1.name}.[$property1] = ${selector2.name}.[$property2]"
}
case class SameNodeCondition(selector1: Selector, selector2: Selector, path: Option[String]) extends JoinCondition {
  override def build(): String = path match {
    case Some(x) => s"ISSAMENODE(${selector1.name}, ${selector2.name}, [$x])"
    case None => s"ISSAMENODE(${selector1.name}, ${selector2.name})"
  }
}
case class ChildNodeCondition(childSelector: Selector, parentSelector: Selector) extends JoinCondition {
  override def build(): String = s"ISCHILDNODE(${childSelector.name}, ${parentSelector.name})"
}
case class DescendantNodeCondition(childSelector: Selector, parentSelector: Selector) extends JoinCondition {
  override def build(): String = s"ISDESCENDANTNODE(${childSelector.name}, ${parentSelector.name})"
}
