package com.xebialabs.xlplatform.repository.jcrsql2

class QueryParameters {
  var i: Int = 0
  var bindings: Map[String, AnyRef] = Map()

  def next = {
    i += 1
    i
  }

  def bind(value: AnyRef) = {
    val paramName: String = s"p$next"
    bindings = bindings + ((paramName, value))
    paramName
  }
}

sealed trait QueryCommand {
  def build(parameters: QueryParameters): String
}

sealed trait Column {
  def build(): String
}
case class FullProperty(selector: Selector) extends Column {
  override def build(): String = s"${selector.name}.*"
}
case class PropertyColumn(selector: Selector, property: String, columnName: Option[String] = None) extends Column {
  def build() = columnName match {
    case Some(x) => s"${selector.name}.[$property] AS $x"
    case None => s"${selector.name}.[$property]"
  }
}

case class Query(columns: Seq[Column], distinct: Boolean, from: Source, where: Constraint) extends QueryCommand {
  def from(source: Source) = {}

  private[this] def cols = distinct match {
    case true => s"DISTINCT ${columns.map(_.build()).mkString(",")}"
    case false => s"${columns.map(_.build()).mkString(",")}"
  }
  override def build(parameters: QueryParameters): String = s"SELECT $cols FROM ${from.build()} WHERE ${where.build(parameters)}"
}

object QueryBuilder {
  def from(source: Source) = new ContinuedQueryBuilder(Seq(), source)

  class ContinuedQueryBuilder(cols: Seq[Column], source: Source) {
    def select(col: Column) = new ContinuedQueryBuilder(col +: cols, source)
    def where(constraint: Constraint) = Query(cols, false, source, constraint)
  }
}