package com.xebialabs.deployit

import javax.jcr.SimpleCredentials

import com.typesafe.config.Config
import com.xebialabs.deployit.XlpJcrRepositoryConfig.jcrAdminCredentials
import com.xebialabs.deployit.jcr.JcrConstants._
import org.springframework.beans.factory.annotation.Autowired


class XlpJcrRepositoryConfig @Autowired()(repositoryName: String, repositoryConfiguration: Config)
  extends XlpRepositoryConfig(repositoryName) {

  override def repositoryConfig: Config = repositoryConfiguration

  /**
    * Returns repository admin id credentials (admin OR jcr_admin)
    *
    * @return jcr admin id user credentials
    */
  override def credentials: RepoCredentials = jcrAdminCredentials

}

object XlpJcrRepositoryConfig {
  val jcrAdminCredentials = JcrCredentials(new SimpleCredentials(JCR_ADMIN_USERNAME, JCR_ADMIN_PASSWORD.toCharArray))

}