package com.xebialabs.deployit.jcr

import javax.jcr.Session

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.beans.BeanProperty
import scala.language.implicitConversions

object ScalaJcrTemplate {
  def apply(jcrTemplate: JcrTemplate): ScalaJcrTemplate = new ScalaJcrTemplate(jcrTemplate)

  implicit def javaTemplate2scala(jcrTemplate: JcrTemplate): ScalaJcrTemplate = apply(jcrTemplate)
}

@Component("scalaJcrTemplate")
class ScalaJcrTemplate @Autowired() (@BeanProperty val jcrTemplate: JcrTemplate) {

  def execute[T](callback: Session => T) = {
    jcrTemplate.execute(new JcrCallback[T] {
      override def doInJcr(session: Session): T = callback(session)
    })
  }

  def execute[T](createNewSession: Boolean)(callback: Session => T) = {
    jcrTemplate.execute(new JcrCallback[T] {
      override def doInJcr(session: Session): T = callback(session)
    }, createNewSession)
  }
}
