package com.xebialabs.xlplatform.repository

import java.util.concurrent.atomic.AtomicInteger

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.repository.{RepositoryService, SearchParameters}
import com.xebialabs.license.service.LicenseCiCounterFactory
import com.xebialabs.license.{License, LicenseCiCounter, LicenseProperty}

import scala.collection.JavaConverters._

class JcrLicenseCiCounterFactory(repositoryService: RepositoryService) extends LicenseCiCounterFactory {

  override def create(license: License): LicenseCiCounter = {
    val restrictions = license.getMapValue(LicenseProperty.MAX_NUMBER_OF_CIS).asScala.map {
      case (typeString, n) => (Type.valueOf(typeString), n.toInt)
    }
    val counter = new LicenseCiCounter(restrictions.toMap)
    countRestrictedCisInRepo(repositoryService, counter)
    counter
  }

  def countRestrictedCisInRepo(repositoryService: RepositoryService, counter: LicenseCiCounter) {
    counter.allowedCiAmounts.keySet.foreach { t =>
      val criteria = new SearchParameters()
      criteria.setType(t)
      counter.typeCounter.put(t, new AtomicInteger(repositoryService.list(criteria).size()))
    }
  }
}
