package com.xebialabs.deployit.repository;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;


public class NodeReaderContext {

    private static final ThreadLocal<NodeReaderContext> CONTEXT_HOLDER = new ThreadLocal<NodeReaderContext>() {
        @Override
        protected NodeReaderContext initialValue() {
            logger.trace("Creating new NodeReaderContext");
            return new NodeReaderContext();
        }
    };

    private AtomicInteger references = new AtomicInteger(0);
    private Map<String, ConfigurationItem> context = new HashMap<>();

    NodeReaderContext() {
    }

    public static NodeReaderContext get() {
        return CONTEXT_HOLDER.get();
    }

    public static void clear() {
        CONTEXT_HOLDER.remove();
    }

    boolean hasItem(String uuid) {
        return context.containsKey(uuid);
    }

    ConfigurationItem get(String uuid) {
        return context.get(uuid);
    }

    void put(String uuid, ConfigurationItem item) {
        context.put(uuid, item);
    }

    public NodeReaderContext hold() {
        if (logger.isTraceEnabled())
            logger.trace("Increasing # of NodeReaderContext leases to {}", references.get() + 1);

        references.incrementAndGet();
        return this;
    }

    public void release() {
        if (logger.isTraceEnabled())
            logger.trace("Decreasing # of NodeReaderContext leases to {}", references.get() - 1);

        if (references.decrementAndGet() <= 0) {
            logger.trace("Removing NodeReaderContext from context holder");
            CONTEXT_HOLDER.remove();
        }
    }

    private static final Logger logger = LoggerFactory.getLogger(NodeReaderContext.class);
}
