package com.xebialabs.deployit.repository

import java.util.{List => JList}

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.util.Tuple
import collection.JavaConverters._

class RepositoryUtils(val repositoryService: RepositoryService) {

  def readTree(copyCommands: JList[Tuple[String, String]]): Seq[Type] =
    copyCommands.asScala.flatMap  { t =>
      val id = t.getA
      val sp = new SearchParameters()
      sp.setAncestor(id)
      repositoryService.list(sp).asScala.map(_.getType) :+
        repositoryService.read(id).asInstanceOf[ConfigurationItem].getType
    }

}
