package com.xebialabs.xlplatform.repository

import javax.jcr.Property

import com.xebialabs.deployit.jcr.{JcrTemplate, ScalaJcrTemplate}
import com.xebialabs.deployit.repository.PathHelper.{buildId, getAbsolutePathFromId}

class JcrAdvancedRepositoryService(jcrTemplate: JcrTemplate) extends AdvancedRepositoryService {

  override def readPropertyAsString(id: String, propertyName: String): String = {
    ScalaJcrTemplate(jcrTemplate).execute { session =>
      val propertyPath: String = getAbsolutePathFromId(buildId(id, propertyName))
      if (session.propertyExists(propertyPath)) {
        val property: Property = session.getProperty(propertyPath)
        property.getString
      } else {
        null
      }
    }
  }
}
