package com.xebialabs.xlplatform.repository.jcrsql2

sealed trait JoinType {
  override def toString: String = this match {
    case Inner => "INNER"
    case LeftOuter => "LEFT OUTER"
    case RightOuter => "RIGHT OUTER"
    //    case FullOuter => "FULL OUTER"
    //    case Cross => "CROSS"
  }
}
case object Inner extends JoinType
case object LeftOuter extends JoinType
case object RightOuter extends JoinType
// Below are Modeshape 4 extensions...
//case object FullOuter extends JoinType
//case object Cross extends JoinType


sealed trait Source {
  def innerJoin(source: Source): JoinBuilder = JoinBuilder(this, Inner, source)
  def leftJoin(source: Source): JoinBuilder = JoinBuilder(this, LeftOuter, source)
  def rightJoin(source: Source): JoinBuilder = JoinBuilder(this, RightOuter, source)

  def build(): String
}

case class Join(left: Source, joinType: JoinType, right: Source, condition: JoinCondition) extends Source {
  override def build(): String = s"${left.build()} $joinType JOIN ${right.build()} ON ${condition.build()}"
}

case class Selector(name: String, nodeTypeName: String) extends Source {
  def build() = s"[$nodeTypeName] AS $name"
}

case class JoinBuilder(left: Source, joinType: JoinType, right: Source) {
  def on(condition: JoinCondition): Join = Join(left, joinType, right, condition)
}
