package com.xebialabs.xlplatform.jcr

import java.util.concurrent.ExecutionException
import javax.jcr.{Repository, SimpleCredentials}

import com.xebialabs.deployit.jcr.{JcrTemplate, ScalaJcrTemplate}
import com.xebialabs.xlplatform.XlRepositoryFactory
import com.xebialabs.xlplatform.repository.{XlRepositoryConfig, XlRepositoryInitializer}
import com.xebialabs.xlplatform.security.ModeshapeUserService
import org.modeshape.jcr.{JcrRepository, ModeShapeEngine}
import org.slf4j.{Logger, LoggerFactory}

class ModeShapeRepositoryFactoryBean(modeshapeConfiguration: ModeshapeConfiguration, xlRepositoryConfig: XlRepositoryConfig) extends XlRepositoryFactory {

  private var engine: ModeShapeEngine = _

  private var repository: JcrRepository = _

  override def afterPropertiesSet(): Unit = {
    logger.info("Starting Modeshape repository")
    engine = new ModeShapeEngine
    engine.start()
    val modeShapeConfig = modeshapeConfiguration.modeShapeConfig
    repository = engine.deploy(modeShapeConfig)
    new XlRepositoryInitializer(repository, xlRepositoryConfig).init()

    val creds: SimpleCredentials = xlRepositoryConfig.credentials.get.asInstanceOf[SimpleCredentials]
    new ModeshapeUserService(ScalaJcrTemplate(new JcrTemplate(repository, creds)))
      .init(new String(creds.getPassword))
  }

  override def getObject: Repository = repository

  override def destroy(): Unit = {
    val shutdown = engine.shutdown()
    try {
      if (!shutdown.get) {
        throw new IllegalStateException("Did not shutdown...")
      }
    }
    catch {
      case e: InterruptedException =>
        Thread.currentThread.interrupt()
        throw new IllegalStateException("Failed to shutdown", e)
      case e: ExecutionException =>
        throw new IllegalStateException("Failed to shutdown", e)
    }
  }

  private val logger: Logger = LoggerFactory.getLogger(classOf[ModeShapeRepositoryFactoryBean])

}
