package com.xebialabs.xlplatform.jcr.modeshape

import javax.jcr.{Repository, SimpleCredentials}

import com.xebialabs.deployit.JcrCredentials
import com.xebialabs.deployit.jcr.{JcrTemplate, ScalaJcrTemplate}
import com.xebialabs.xlplatform.repository.{XlJcrRepositoryInitializer, XlRepositoryConfig}
import com.xebialabs.xlplatform.security.ModeshapeUserService
import grizzled.slf4j.Logging

class ModeshapeRepositoryInitializer(xlRepositoryConfig: XlRepositoryConfig) extends XlJcrRepositoryInitializer(xlRepositoryConfig) with Logging {

  override def init(repository: Repository ) = {
    logger.info("Initializing Modeshape repository")
    super.init(repository)
    new ModeshapeUserService(ScalaJcrTemplate(new JcrTemplate(repository, adminCredentials)))
      .init(new String(adminCredentials.getPassword))
    logger.info("Initialized Modeshape repository")
  }

  private val adminCredentials: SimpleCredentials = xlRepositoryConfig.credentials match {
    case JcrCredentials(creds: SimpleCredentials) => creds
    case _ => throw new IllegalArgumentException("Credentials must be provided and be JcrCredentials with SimpleCredentials")
  }

}
