package com.xebialabs.xlplatform.jcr

import java.util.concurrent.ExecutionException
import javax.annotation.PostConstruct
import javax.jcr.Repository

import com.xebialabs.xlplatform.XlRepositoryFactory
import com.xebialabs.xlplatform.jcr.modeshape.ModeshapeRepositoryInitializer
import grizzled.slf4j.Logging
import org.modeshape.jcr.{JcrRepository, ModeShapeEngine}

class ModeShapeRepositoryFactoryBean(modeshapeConfiguration: ModeshapeConfiguration, modeshapeInitializer: ModeshapeRepositoryInitializer) extends XlRepositoryFactory with Logging {

  logger.info("Starting Modeshape repository")
  private val engine: ModeShapeEngine = new ModeShapeEngine
  engine.start()
  val modeShapeConfig = modeshapeConfiguration.modeShapeConfig
  private val repository: JcrRepository = engine.deploy(modeShapeConfig)
  logger.info("Started Modeshape repository")

  @PostConstruct
  def initialize(): Unit = {
    modeshapeInitializer.init(repository)
  }

  override def getObject: Repository = repository

  override def destroy(): Unit = {
    val shutdown = engine.shutdown()
    try {
      if (!shutdown.get) {
        throw new IllegalStateException("Did not shutdown...")
      }
    }
    catch {
      case e: InterruptedException =>
        Thread.currentThread.interrupt()
        throw new IllegalStateException("Failed to shutdown", e)
      case e: ExecutionException =>
        throw new IllegalStateException("Failed to shutdown", e)
    }
  }
}
