package com.xebialabs.xlplatform.xlrepository.tck

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.repository.{RepositoryMetadataService, HistoryService, RepositoryService}
import com.xebialabs.license.service.{LicenseServiceImpl, LicenseService}
import com.xebialabs.xlplatform.xlrepository.tck.util.CiHelper

trait RepositoryFactory[A] {
  var repository: RepositoryService = _
  var metadataService: RepositoryMetadataService = _
  var history: HistoryService = _
  def ciHelper: CiHelper = new CiHelper(repository)

  def boot(): Unit
  def shutdown(): Unit

  def getRepositoryService(licenseService: LicenseService): RepositoryService
  def getRepositoryMetadataService: RepositoryMetadataService
  def getHistoryService: HistoryService

  def getStoredValue[T <: AnyRef](ci: ConfigurationItem, property: String): T
  def setStoredValue[T <: AnyRef](ci: ConfigurationItem, property: String, value: T): Unit
  def hasProperty(id: String, propertyName: String): Boolean
  def removeProperty(id: String, propertyName: String): Unit
  def getNumberOfVersions(id: String, ctx: RepoContext = EmptyContext): (Long, NonEmptyContext)
  def removeLabel(path: String, label: String): Unit
  def getRepositoryId: String

  def withLicense(licensePath: String)(body: => Unit): Unit = {
    val _currentRepo = repository
    try {
      val license: LicenseServiceImpl = new LicenseServiceImpl(licensePath, "XL Deploy", getRepositoryMetadataService)
      repository = getRepositoryService(license)
      body
    } finally {
      repository = _currentRepo
    }
  }

  sealed trait RepoContext
  case class NonEmptyContext(metaData: A) extends RepoContext
  case object EmptyContext extends RepoContext
}
