package com.xebialabs.xlplatform.xlrepository.tck

import java.security.Security

import com.xebialabs.xlplatform.xlrepository.tck.suites._
import org.bouncycastle.jce.provider.BouncyCastleProvider

abstract class RepositoryTck
  extends RepositoryCrudSuite
    with RepositoryReferentialIntegritySuite
    with RepositoryStructuralIntegritySuite
    with RepositoryTypeSystemSuite
    with RepositorySearchSuite
    with RepositoryConflictSuite
    with ArtifactSuite
    with HistorySuite
    with RepositoryEventSuite
    with UniquenessValidationSuite
    with RepositoryLicenseEnforcementSuite
    with TextSearchSuite
{
  self: RepositoryFactory[_] =>

  if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
    Security.addProvider(new BouncyCastleProvider)
  }

}
