package com.xebialabs.xlplatform.xlrepository.tck.cis

import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import java.util.{List => JList, Set => JSet}

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION)
class Basic extends BaseConfigurationItem {

}

@Metadata(root = Metadata.ConfigurationItemRoot.INFRASTRUCTURE)
class OtherRoot extends BaseConfigurationItem {}

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION)
class Parent extends BaseConfigurationItem {
  @Property(required = false) var prop: String = _
  @Property(asContainment = true) var myChildren: JSet[Child] = _
}

@Metadata(root = ConfigurationItemRoot.NESTED)
class Child extends BaseConfigurationItem {
  @Property(required = false) var prop: String = _
}

class ChildSub extends Child {
}

class ChildWithKnownParent extends Child {
  @Property(required = false, asContainment = true) var parent: Parent = _
}

@Metadata(root = ConfigurationItemRoot.NESTED)
class IsNotAChild extends BaseConfigurationItem {
}

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION)
class OrderedParent extends BaseConfigurationItem {
  @Property(asContainment = true) var offspring: JList[Child] = _
}

class ParentSub extends Parent {
}

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION)
class StringProp extends BaseConfigurationItem {
  @Property var string: String = _
}

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION)
class Referencer extends BaseConfigurationItem {
  @Property(required = false) var ref: Referencer = _
}

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION)
class MultiReferencer extends BaseConfigurationItem {
  @Property(required = false) var ref: MultiReferencer = _
  @Property(required = false) var refList: JList[MultiReferencer] = _
  @Property(required = false) var refSet: JSet[MultiReferencer] = _
}

@Metadata(root = Metadata.ConfigurationItemRoot.BY_ROOT_NAME, rootName = "Tests")
class RootByName extends BaseConfigurationItem
