package com.xebialabs.xlplatform.xlrepository.tck.cis

import com.google.common.collect.Lists._
import com.xebialabs.deployit.plugin.api.udm.{Property, Metadata}
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import java.util.{List => JList, Set => JSet, Map => JMap}

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION)
class Password extends BaseConfigurationItem {
  @Property(password = true) var password: String = _
}

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION)
class Hidden extends BaseConfigurationItem {
  @Property(hidden = true, required = false, defaultValue = "Hidden") var hidden: String = _
}

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION)
class Transient extends BaseConfigurationItem {
  @Property(isTransient = true, required = false, defaultValue = "Transient") var transient: String = _
}

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION)
class ListOfString extends BaseConfigurationItem {
  @Property() var prop: JList[String] = _
}

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION)
class SetOfString extends BaseConfigurationItem {
  @Property() var prop: JSet[String] = _
}

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION)
class MapStringString extends BaseConfigurationItem {
  @Property() var prop: JMap[String, String] = _
}

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION)
class PasswordListOfString extends BaseConfigurationItem {
  @Property(password = true) var prop: JList[String] = _
}

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION)
class PasswordSetOfString extends BaseConfigurationItem {
  @Property(password = true) var prop: JSet[String] = _
}

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION)
class PasswordMapStringString extends BaseConfigurationItem {
  @Property(password = true) var prop: JMap[String, String] = _
}

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION) class AllProperties extends BaseConfigurationItem {
  @Property(required = false) var stringList: JList[String] = null
  @Property(required = false) var stringSet: JSet[String] = null
  @Property(required = false) var stringStringMap: JMap[String, String] = null
}

class AsContainmentChild extends BaseConfigurationItem

@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION) class AsContainmentList extends BaseConfigurationItem {
  @Property(asContainment = true) private var asContainmentList: JList[AsContainmentChild] = newArrayList[AsContainmentChild]()

  def getAsContainmentList: JList[AsContainmentChild] = {
    asContainmentList
  }
}