package com.xebialabs.xlplatform.xlrepository.tck.suites

import com.xebialabs.deployit.repository.ItemInUseException
import com.xebialabs.xlplatform.xlrepository.tck.RepositoryFactory
import com.xebialabs.xlplatform.xlrepository.tck.cis.Referencer
import com.xebialabs.xlplatform.xlrepository.tck.util.RepositorySuiteBase

trait RepositoryReferentialIntegritySuite extends RepositorySuiteBase { self: RepositoryFactory[_] =>
  import com.xebialabs.xlplatform.xlrepository.tck.util.CiHelper._

  private val gen = generator.genFor("tck-refint")

  describe("The XL Repository Referential Integrity Suite") {
    it("should not create a ConfigurationItem with an invalid reference") {
      val referencer: Referencer = ciHelper.constructCi("repo-tck.Referencer", gen.nextId())
      val referenced: Referencer = ciHelper.constructCi("repo-tck.Referencer", gen.nextId())
      referencer.ref = referenced
      an[Exception] should be thrownBy {
        repository.create(referencer)
      }
    }

    it("should persist a ConfigurationItem with its references") {
      val referencer: Referencer = ciHelper.constructCi("repo-tck.Referencer", gen.nextId())
      val referenced: Referencer = ciHelper.constructCi("repo-tck.Referencer", gen.nextId())
      referencer.ref = referenced
      repository.create(referenced, referencer)
      referenced should existInRepository
      referencer should existInRepository
    }

    it("should not be able to delete a referenced ConfigurationItem") {
      val referencer: Referencer = ciHelper.constructCi("repo-tck.Referencer", gen.nextId())
      val referenced: Referencer = ciHelper.constructCi("repo-tck.Referencer", gen.nextId())
      referencer.ref = referenced
      repository.create(referenced, referencer)
      val ex = intercept[ItemInUseException] {
        repository.delete(referenced.getId)
      }
      ex.getMessage should include(referencer.getId)
      referenced should existInRepository
    }

  }

}
