/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.xlrepository.tck.suites;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.xlplatform.xlrepository.tck.RepositoryFactory;
import com.xebialabs.xlplatform.xlrepository.tck.cis.Child;
import com.xebialabs.xlplatform.xlrepository.tck.cis.ChildWithKnownParent;
import com.xebialabs.xlplatform.xlrepository.tck.cis.OrderedParent;
import com.xebialabs.xlplatform.xlrepository.tck.cis.OtherRoot;
import com.xebialabs.xlplatform.xlrepository.tck.cis.Parent;
import com.xebialabs.xlplatform.xlrepository.tck.cis.RootByName;
import com.xebialabs.xlplatform.xlrepository.tck.util.CiHelper$;
import com.xebialabs.xlplatform.xlrepository.tck.util.IdGenerator;
import com.xebialabs.xlplatform.xlrepository.tck.util.RepositorySuiteBase;
import java.io.Serializable;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.enablers.Containing$;
import org.scalatest.enablers.Size$;
import org.scalatest.matchers.Matcher;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Symbol$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u00053\u0001\u0002B\u0003\u0011\u0002\u0007\u0005!C\u000b\u0005\u0006?\u0001!\t\u0001\t\u0005\bI\u0001\u0011\r\u0011\"\u0003&\u0011\u001dI\u0003A1A\u0005\n\u0015\u0012!EU3q_NLGo\u001c:z'R\u0014Xo\u0019;ve\u0006d\u0017J\u001c;fOJLG/_*vSR,'B\u0001\u0004\b\u0003\u0019\u0019X/\u001b;fg*\u0011\u0001\"C\u0001\u0004i\u000e\\'B\u0001\u0006\f\u00031AHN]3q_NLGo\u001c:z\u0015\taQ\"\u0001\u0006yYBd\u0017\r\u001e4pe6T!AD\b\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\t\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001\u0019\u0012\u0004\u0005\u0002\u0015/5\tQCC\u0001\u0017\u0003\u0015\u00198-\u00197b\u0013\tARC\u0001\u0004B]f\u0014VM\u001a\t\u00035ui\u0011a\u0007\u0006\u00039\u001d\tA!\u001e;jY&\u0011ad\u0007\u0002\u0014%\u0016\u0004xn]5u_JL8+^5uK\n\u000b7/Z\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003\u0005\u0002\"\u0001\u0006\u0012\n\u0005\r*\"\u0001B+oSR\f1aZ3o+\u00051\u0003C\u0001\u000e(\u0013\tA3DA\u0006JI\u001e+g.\u001a:bi>\u0014\u0018a\u0002;fgR<UM\u001c\n\u0004W=\nd\u0001\u0002\u0017\u0001\u0001)\u0012A\u0002\u0010:fM&tW-\\3oizR!AL\t\u0002\rq\u0012xn\u001c;?!\t\u0001\u0004!D\u0001\u0006a\t\u0011\u0004\bE\u00024iYj\u0011aB\u0005\u0003k\u001d\u0011\u0011CU3q_NLGo\u001c:z\r\u0006\u001cGo\u001c:z!\t9\u0004\b\u0004\u0001\u0005\u0013e\u0002\u0011\u0011!A\u0001\u0006\u0003Q$aA0%cE\u00111H\u0010\t\u0003)qJ!!P\u000b\u0003\u000f9{G\u000f[5oOB\u0011AcP\u0005\u0003\u0001V\u00111!\u00118z\u0001")
public interface RepositoryStructuralIntegritySuite
extends RepositorySuiteBase {
    public void com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$_setter_$com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen_$eq(IdGenerator var1);

    public void com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$_setter_$com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$testGen_$eq(IdGenerator var1);

    public IdGenerator com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen();

    public IdGenerator com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$testGen();

    private static Directory createDir$1(String id) {
        return (Directory)Type.valueOf(Directory.class).getDescriptor().newInstance(id);
    }

    public static void $init$(RepositoryStructuralIntegritySuite $this) {
        $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$_setter_$com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen_$eq($this.generator().genFor("tck-structint"));
        $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$_setter_$com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$testGen_$eq($this.testsRootGenerator().genFor("tck-structint"));
        $this.describe("The XL Repository Structural Integrity Suite", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            $this.it().apply("should not store a ConfigurationItem under the wrong root", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                Object ci = ((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.Basic"), "Applications/wrong-root");
                $this.an(ClassTag$.MODULE$.apply(Checks.IncorrectArgumentException.class)).should($this.be(), Prettifier$.MODULE$.default(), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 24)).thrownBy((Function0)(JFunction0.mcV.sp & Serializable)() -> ((RepositoryFactory)((Object)$this)).repository().create(new ConfigurationItem[]{ci}));
                return $this.convertToAnyShouldWrapper(ci, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 27), Prettifier$.MODULE$.default()).shouldNot((Matcher)$this.existInRepository());
            }, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 22));
            $this.it().apply("should not store a ConfigurationItem under a non-root", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                Object ci = ((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.Basic"), "no-root");
                $this.an(ClassTag$.MODULE$.apply(Checks.IncorrectArgumentException.class)).should($this.be(), Prettifier$.MODULE$.default(), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32)).thrownBy((Function0)(JFunction0.mcV.sp & Serializable)() -> ((RepositoryFactory)((Object)$this)).repository().create(new ConfigurationItem[]{ci}));
                return $this.convertToAnyShouldWrapper(ci, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35), Prettifier$.MODULE$.default()).shouldNot((Matcher)$this.existInRepository());
            }, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
            $this.it().apply("should not store a child ConfigurationItem under a root", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                Object ci = ((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.Child"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().nextId());
                $this.an(ClassTag$.MODULE$.apply(Checks.IncorrectArgumentException.class)).should($this.be(), Prettifier$.MODULE$.default(), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40)).thrownBy((Function0)(JFunction0.mcV.sp & Serializable)() -> ((RepositoryFactory)((Object)$this)).repository().create(new ConfigurationItem[]{ci}));
                return $this.convertToAnyShouldWrapper(ci, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43), Prettifier$.MODULE$.default()).shouldNot((Matcher)$this.existInRepository());
            }, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
            $this.it().apply("should not store a child ConfigurationItem under a non-root", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                Object ci = ((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.Child"), "no-root");
                $this.an(ClassTag$.MODULE$.apply(Checks.IncorrectArgumentException.class)).should($this.be(), Prettifier$.MODULE$.default(), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48)).thrownBy((Function0)(JFunction0.mcV.sp & Serializable)() -> ((RepositoryFactory)((Object)$this)).repository().create(new ConfigurationItem[]{ci}));
                return $this.convertToAnyShouldWrapper(ci, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51), Prettifier$.MODULE$.default()).shouldNot((Matcher)$this.existInRepository());
            }, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
            $this.ignore("should not store a rooted ConfigurationItem as a nested ConfigurationItem", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                Object correct = ((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.Basic"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().nextId());
                ((RepositoryFactory)((Object)$this)).repository().create(new ConfigurationItem[]{correct});
                Object ci = ((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.Basic"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().subId((ConfigurationItem)correct));
                $this.an(ClassTag$.MODULE$.apply(Checks.IncorrectArgumentException.class)).should($this.be(), Prettifier$.MODULE$.default(), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59)).thrownBy((Function0)(JFunction0.mcV.sp & Serializable)() -> ((RepositoryFactory)((Object)$this)).repository().create(new ConfigurationItem[]{ci}));
                return $this.convertToAnyShouldWrapper(ci, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62), Prettifier$.MODULE$.default()).shouldNot((Matcher)$this.existInRepository());
            }, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
            $this.it().apply("should store a child ConfigurationItem as a nested ConfigurationItem", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                Object correct = ((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.Parent"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().nextId());
                ((RepositoryFactory)((Object)$this)).repository().create(new ConfigurationItem[]{correct});
                Object ci = ((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.Child"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().subId((ConfigurationItem)correct));
                ((RepositoryFactory)((Object)$this)).repository().create(new ConfigurationItem[]{ci});
                return $this.convertToAnyShouldWrapper(ci, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70), Prettifier$.MODULE$.default()).should((Matcher)$this.existInRepository());
            }, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            $this.it().apply("should store a child subclass ConfigurationItem as a nested ConfigurationItem", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                Object correct = ((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.Parent"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().nextId());
                ((RepositoryFactory)((Object)$this)).repository().create(new ConfigurationItem[]{correct});
                Object ci = ((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.ChildSub"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().subId((ConfigurationItem)correct));
                ((RepositoryFactory)((Object)$this)).repository().create(new ConfigurationItem[]{ci});
                return $this.convertToAnyShouldWrapper(ci, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78), Prettifier$.MODULE$.default()).should((Matcher)$this.existInRepository());
            }, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
            $this.it().apply("should store a child ConfigurationItem as a nested ConfigurationItem under a parent subclass", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                Object correct = ((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.ParentSub"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().nextId());
                ((RepositoryFactory)((Object)$this)).repository().create(new ConfigurationItem[]{correct});
                Object ci = ((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.Child"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().subId((ConfigurationItem)correct));
                ((RepositoryFactory)((Object)$this)).repository().create(new ConfigurationItem[]{ci});
                $this.convertToAnyShouldWrapper(ci, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86), Prettifier$.MODULE$.default()).should((Matcher)$this.existInRepository());
                return $this.convertToAnyShouldWrapper(ci, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87), Prettifier$.MODULE$.default()).should($this.have());
            }, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            $this.it().apply("should read/write CIs with circular references", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                Object correct = ((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.Parent"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().nextId());
                ((RepositoryFactory)((Object)$this)).repository().create(new ConfigurationItem[]{correct});
                Object ci = ((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.ChildWithKnownParent"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().subId((ConfigurationItem)correct));
                ((RepositoryFactory)((Object)$this)).repository().create(new ConfigurationItem[]{ci});
                ChildWithKnownParent read = (ChildWithKnownParent)((RepositoryFactory)((Object)$this)).repository().read(ci.getId());
                $this.convertToAnyShouldWrapper((Object)read.parent(), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96), Prettifier$.MODULE$.default()).should($this.not()).equal(null);
                $this.convertToAnyShouldWrapper(read.parent().myChildren(), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97), Prettifier$.MODULE$.default()).should($this.have()).size(1L, Size$.MODULE$.sizeOfJavaCollection());
                return $this.convertToAnyShouldWrapper(read.parent().myChildren(), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98), Prettifier$.MODULE$.default()).should($this.contain().apply((Object)read), (Object)Containing$.MODULE$.containingNatureOfJavaCollection(Equality$.MODULE$.default()));
            }, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            $this.it().apply("should not store a child ConfigurationItem nested under a non-matching parent ConfigurationItem", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                Object correct = ((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.Parent"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().nextId());
                ((RepositoryFactory)((Object)$this)).repository().create(new ConfigurationItem[]{correct});
                Object ci = ((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.IsNotAChild"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().subId((ConfigurationItem)correct));
                $this.an(ClassTag$.MODULE$.apply(Checks.IncorrectArgumentException.class)).should($this.be(), Prettifier$.MODULE$.default(), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105)).thrownBy((Function0)(JFunction0.mcV.sp & Serializable)() -> ((RepositoryFactory)((Object)$this)).repository().create(new ConfigurationItem[]{ci}));
                return $this.convertToAnyShouldWrapper(ci, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108), Prettifier$.MODULE$.default()).shouldNot((Matcher)$this.existInRepository());
            }, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            $this.it().apply("should store directory ci with id ending with '/' character", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                Directory ci = RepositoryStructuralIntegritySuite.createDir$1($this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().nextId());
                ((RepositoryFactory)((Object)$this)).repository().create(new ConfigurationItem[]{ci});
                Directory ci2 = RepositoryStructuralIntegritySuite.createDir$1(new StringBuilder(11).append(ci.getId()).append("/something/").toString());
                ((RepositoryFactory)((Object)$this)).repository().create(new ConfigurationItem[]{ci2});
                ConfigurationItem read = ((RepositoryFactory)((Object)$this)).repository().read(ci2.getId());
                $this.convertToAnyShouldWrapper(ci2, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118), Prettifier$.MODULE$.default()).should((Matcher)$this.existInRepository());
                $this.convertToStringShouldWrapper(ci2.getId(), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119), Prettifier$.MODULE$.default()).should($this.be().apply((Object)read.getId()));
                return $this.convertToStringShouldWrapper(ci2.getName(), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120), Prettifier$.MODULE$.default()).should($this.be().apply((Object)read.getName()));
            }, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
            $this.describe("list of contained ConfigurationItems", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                $this.it().apply("should be automatically updated when a new child is stored", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcZ.sp & Serializable)() -> {
                    OrderedParent correct = (OrderedParent)((Object)((Object)((Object)((Object)((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.OrderedParent"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().nextId())))));
                    ((RepositoryFactory)((Object)$this)).repository().create((ConfigurationItem[])new OrderedParent[]{correct});
                    Child kid1 = (Child)((Object)((Object)((Object)((Object)((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.Child"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().subId((ConfigurationItem)correct))))));
                    ((RepositoryFactory)((Object)$this)).repository().create((ConfigurationItem[])new Child[]{kid1});
                    Child kid2 = (Child)((Object)((Object)((Object)((Object)((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.Child"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().subId((ConfigurationItem)correct))))));
                    ((RepositoryFactory)((Object)$this)).repository().create((ConfigurationItem[])new Child[]{kid2});
                    OrderedParent read = (OrderedParent)((RepositoryFactory)((Object)$this)).repository().read(correct.getId());
                    String string = ((BaseConfigurationItem)read.offspring().get(0)).getId();
                    String string2 = kid1.getId();
                    boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
                    String string3 = ((BaseConfigurationItem)read.offspring().get(1)).getId();
                    String string4 = kid2.getId();
                    return !(string3 != null ? !string3.equals(string4) : string4 != null);
                }, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
                $this.it().apply("should be stored in specific order", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0)(JFunction0.mcZ.sp & Serializable)() -> {
                    OrderedParent correct = (OrderedParent)((Object)((Object)((Object)((Object)((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.OrderedParent"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().nextId())))));
                    Child kid1 = (Child)((Object)((Object)((Object)((Object)((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.Child"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().subId((ConfigurationItem)correct))))));
                    Child kid2 = (Child)((Object)((Object)((Object)((Object)((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.Child"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().subId((ConfigurationItem)correct))))));
                    correct.offspring().add(kid2);
                    correct.offspring().add(kid1);
                    ((RepositoryFactory)((Object)$this)).repository().create((ConfigurationItem[])new BaseConfigurationItem[]{correct, kid1, kid2});
                    OrderedParent read = (OrderedParent)((RepositoryFactory)((Object)$this)).repository().read(correct.getId());
                    String string = ((BaseConfigurationItem)read.offspring().get(0)).getId();
                    String string2 = kid2.getId();
                    boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
                    String string3 = ((BaseConfigurationItem)read.offspring().get(1)).getId();
                    String string4 = kid1.getId();
                    return !(string3 != null ? !string3.equals(string4) : string4 != null);
                }, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
                $this.it().apply("should remove from the list when a child is removed", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                    OrderedParent correct = (OrderedParent)((Object)((Object)((Object)((Object)((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.OrderedParent"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().nextId())))));
                    ((RepositoryFactory)((Object)$this)).repository().create((ConfigurationItem[])new OrderedParent[]{correct});
                    Child kid1 = (Child)((Object)((Object)((Object)((Object)((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.Child"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().subId((ConfigurationItem)correct))))));
                    ((RepositoryFactory)((Object)$this)).repository().create((ConfigurationItem[])new Child[]{kid1});
                    ((RepositoryFactory)((Object)$this)).repository().delete(new String[]{kid1.getId()});
                    OrderedParent read = (OrderedParent)((RepositoryFactory)((Object)$this)).repository().read(correct.getId());
                    return $this.convertToAnyShouldWrapper(read.offspring(), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155), Prettifier$.MODULE$.default()).shouldBe(Symbol$.MODULE$.apply("empty"), (.less.colon.less)$less$colon$less$.MODULE$.refl());
                }, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
                $this.it().apply("should only add contained ConfigurationItems to the list", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                    OrderedParent correct = (OrderedParent)((Object)((Object)((Object)((Object)((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.OrderedParent"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().nextId())))));
                    OrderedParent correct2 = (OrderedParent)((Object)((Object)((Object)((Object)((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.OrderedParent"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().nextId())))));
                    ((RepositoryFactory)((Object)$this)).repository().create((ConfigurationItem[])new OrderedParent[]{correct, correct2});
                    Child kid = (Child)((Object)((Object)((Object)((Object)((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.Child"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().subId((ConfigurationItem)correct2))))));
                    return $this.an(ClassTag$.MODULE$.apply(Exception.class)).should($this.be(), Prettifier$.MODULE$.default(), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163)).thrownBy((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                        correct.offspring().add(kid);
                        ((RepositoryFactory)((Object)$this)).repository().update((ConfigurationItem[])new OrderedParent[]{correct});
                    });
                }, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
                $this.it().apply("should not remove contained ConfigurationItems from the repository when they're removed from the list", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                    OrderedParent correct = (OrderedParent)((Object)((Object)((Object)((Object)((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.OrderedParent"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().nextId())))));
                    Child kid1 = (Child)((Object)((Object)((Object)((Object)((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.Child"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().subId((ConfigurationItem)correct))))));
                    Child kid2 = (Child)((Object)((Object)((Object)((Object)((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.Child"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().subId((ConfigurationItem)correct))))));
                    ((RepositoryFactory)((Object)$this)).repository().create((ConfigurationItem[])new BaseConfigurationItem[]{correct, kid1, kid2});
                    OrderedParent read = (OrderedParent)((RepositoryFactory)((Object)$this)).repository().read(correct.getId());
                    $this.convertToAnyShouldWrapper(read.offspring(), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175), Prettifier$.MODULE$.default()).should($this.have()).size(2L, Size$.MODULE$.sizeOfJavaCollection());
                    $this.convertToStringShouldWrapper(((BaseConfigurationItem)read.offspring().get(0)).getId(), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176), Prettifier$.MODULE$.default()).shouldEqual((Object)kid1.getId(), Equality$.MODULE$.default());
                    read.offspring().remove(0);
                    ((RepositoryFactory)((Object)$this)).repository().update((ConfigurationItem[])new OrderedParent[]{read});
                    OrderedParent read1 = (OrderedParent)((RepositoryFactory)((Object)$this)).repository().read(correct.getId(), false);
                    $this.convertToAnyShouldWrapper(read1.offspring(), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180), Prettifier$.MODULE$.default()).should($this.have()).size(2L, Size$.MODULE$.sizeOfJavaCollection());
                    return $this.convertToStringShouldWrapper(((BaseConfigurationItem)read1.offspring().get(0)).getId(), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181), Prettifier$.MODULE$.default()).shouldEqual((Object)kid2.getId(), Equality$.MODULE$.default());
                }, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
                $this.it().apply("should update to a new order", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                    OrderedParent parent = (OrderedParent)((Object)((Object)((Object)((Object)((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.OrderedParent"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().nextId())))));
                    Child kid1 = (Child)((Object)((Object)((Object)((Object)((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.Child"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().subId((ConfigurationItem)parent))))));
                    Child kid2 = (Child)((Object)((Object)((Object)((Object)((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.Child"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().subId((ConfigurationItem)parent))))));
                    parent.offspring_$eq(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Child[]{kid1, kid2}))).asJava());
                    ((RepositoryFactory)((Object)$this)).repository().create((ConfigurationItem[])new BaseConfigurationItem[]{parent, kid1, kid2});
                    OrderedParent read = (OrderedParent)((RepositoryFactory)((Object)$this)).repository().read(parent.getId());
                    $this.convertToAnyShouldWrapper(read.offspring(), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191), Prettifier$.MODULE$.default()).should($this.have()).size(2L, Size$.MODULE$.sizeOfJavaCollection());
                    $this.convertToStringShouldWrapper(((BaseConfigurationItem)read.offspring().get(0)).getId(), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192), Prettifier$.MODULE$.default()).shouldEqual((Object)kid1.getId(), Equality$.MODULE$.default());
                    read.offspring_$eq(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(read.offspring()).asScala().reverse()).asJava());
                    ((RepositoryFactory)((Object)$this)).repository().update((ConfigurationItem[])new OrderedParent[]{read});
                    OrderedParent read1 = (OrderedParent)((RepositoryFactory)((Object)$this)).repository().read(parent.getId(), false);
                    $this.convertToAnyShouldWrapper(read1.offspring(), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196), Prettifier$.MODULE$.default()).should($this.have()).size(2L, Size$.MODULE$.sizeOfJavaCollection());
                    return $this.convertToStringShouldWrapper(((BaseConfigurationItem)read1.offspring().get(0)).getId(), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197), Prettifier$.MODULE$.default()).shouldEqual((Object)kid2.getId(), Equality$.MODULE$.default());
                }, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
                $this.it().apply("should not add the child a second time when it is updated", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                    OrderedParent parent = (OrderedParent)((Object)((Object)((Object)((Object)((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.OrderedParent"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().nextId())))));
                    Child kid1 = (Child)((Object)((Object)((Object)((Object)((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.stringToType("repo-tck.Child"), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().subId((ConfigurationItem)parent))))));
                    ((RepositoryFactory)((Object)$this)).repository().create((ConfigurationItem[])new BaseConfigurationItem[]{parent, kid1});
                    ((RepositoryFactory)((Object)$this)).repository().update((ConfigurationItem[])new Child[]{kid1});
                    OrderedParent read = (OrderedParent)((RepositoryFactory)((Object)$this)).repository().read(parent.getId());
                    $this.convertToAnyShouldWrapper(read.offspring(), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206), Prettifier$.MODULE$.default()).should($this.have()).size(1L, Size$.MODULE$.sizeOfJavaCollection());
                    return $this.convertToStringShouldWrapper(((BaseConfigurationItem)read.offspring().get(0)).getId(), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207), Prettifier$.MODULE$.default()).shouldEqual((Object)kid1.getId(), Equality$.MODULE$.default());
                }, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
            }, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            $this.describe("directories", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                $this.it().apply("should create and delete a directory", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                    Directory directory = ((RepositoryFactory)((Object)$this)).ciHelper().createDirectory($this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().nextId());
                    $this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)((RepositoryFactory)((Object)$this)).repository().exists(directory.getId())), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214), Prettifier$.MODULE$.default()).shouldEqual((Object)BoxesRunTime.boxToBoolean((boolean)true), Equality$.MODULE$.default());
                    ((RepositoryFactory)((Object)$this)).repository().delete(new String[]{directory.getId()});
                    return $this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)((RepositoryFactory)((Object)$this)).repository().exists(directory.getId())), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216), Prettifier$.MODULE$.default()).shouldEqual((Object)BoxesRunTime.boxToBoolean((boolean)false), Equality$.MODULE$.default());
                }, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
                $this.it().apply("should not create a directory at the root", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> $this.an(ClassTag$.MODULE$.apply(Checks.IncorrectArgumentException.class)).shouldBe($this.thrownBy((Function0)(JFunction0.mcV.sp & Serializable)() -> ((RepositoryFactory)((Object)$this)).repository().create((ConfigurationItem[])new Directory[]{((RepositoryFactory)((Object)$this)).ciHelper().constructConfigurationItem(Directory.class, "dir")})), Prettifier$.MODULE$.default(), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220)), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
                $this.it().apply("should create nested directory structures", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                    Directory directory = ((RepositoryFactory)((Object)$this)).ciHelper().createDirectory($this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().nextId());
                    Directory subDir = ((RepositoryFactory)((Object)$this)).ciHelper().createDirectory($this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().subId((ConfigurationItem)directory));
                    return $this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)((RepositoryFactory)((Object)$this)).repository().exists(subDir.getId())), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228), Prettifier$.MODULE$.default()).shouldEqual((Object)BoxesRunTime.boxToBoolean((boolean)true), Equality$.MODULE$.default());
                }, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
                $this.it().apply("should not store nested configuration items in a directory", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                    Directory directory = ((RepositoryFactory)((Object)$this)).ciHelper().createDirectory($this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().nextId());
                    Child ci = (Child)((Object)((Object)((Object)((Object)((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.classToType(Child.class), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().subId((ConfigurationItem)directory))))));
                    $this.an(ClassTag$.MODULE$.apply(Checks.IncorrectArgumentException.class)).shouldBe($this.thrownBy((Function0)(JFunction0.mcV.sp & Serializable)() -> ((RepositoryFactory)((Object)$this)).repository().create((ConfigurationItem[])new Child[]{ci})), Prettifier$.MODULE$.default(), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
                    return $this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)((RepositoryFactory)((Object)$this)).repository().exists(ci.getId())), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237), Prettifier$.MODULE$.default()).shouldEqual((Object)BoxesRunTime.boxToBoolean((boolean)false), Equality$.MODULE$.default());
                }, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
                $this.it().apply("should store a rooted configuration item in a directory (under the correct root)", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                    Directory directory = ((RepositoryFactory)((Object)$this)).ciHelper().createDirectory($this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().nextId());
                    Parent ci = (Parent)((Object)((Object)((Object)((Object)((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.classToType(Parent.class), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().subId((ConfigurationItem)directory))))));
                    ((RepositoryFactory)((Object)$this)).repository().create((ConfigurationItem[])new Parent[]{ci});
                    return $this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)((RepositoryFactory)((Object)$this)).repository().exists(ci.getId())), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244), Prettifier$.MODULE$.default()).shouldEqual((Object)BoxesRunTime.boxToBoolean((boolean)true), Equality$.MODULE$.default());
                }, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
                $this.it().apply("should not store a rooted configuration item in a directory under the incorrect root", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                    Directory directory = ((RepositoryFactory)((Object)$this)).ciHelper().createDirectory($this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().nextId());
                    OtherRoot ci = (OtherRoot)((Object)((Object)((Object)((Object)((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.classToType(OtherRoot.class), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().subId((ConfigurationItem)directory))))));
                    $this.an(ClassTag$.MODULE$.apply(Checks.IncorrectArgumentException.class)).shouldBe($this.thrownBy((Function0)(JFunction0.mcV.sp & Serializable)() -> ((RepositoryFactory)((Object)$this)).repository().create((ConfigurationItem[])new OtherRoot[]{ci})), Prettifier$.MODULE$.default(), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
                    return $this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)((RepositoryFactory)((Object)$this)).repository().exists(ci.getId())), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253), Prettifier$.MODULE$.default()).shouldEqual((Object)BoxesRunTime.boxToBoolean((boolean)false), Equality$.MODULE$.default());
                }, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
                $this.it().apply("should store a rooted configuration under non-standard root", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                    Directory directory = ((RepositoryFactory)((Object)$this)).ciHelper().createDirectory($this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$testGen().nextId());
                    RootByName ci = (RootByName)((Object)((Object)((Object)((Object)((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.classToType(RootByName.class), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$testGen().subId((ConfigurationItem)directory))))));
                    ((RepositoryFactory)((Object)$this)).repository().create((ConfigurationItem[])new RootByName[]{ci});
                    return $this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)((RepositoryFactory)((Object)$this)).repository().exists(ci.getId())), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260), Prettifier$.MODULE$.default()).shouldEqual((Object)BoxesRunTime.boxToBoolean((boolean)true), Equality$.MODULE$.default());
                }, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
                $this.it().apply("should not store a rooted configuration item when the parent dirs have not been created", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                    Directory dir = ((RepositoryFactory)((Object)$this)).ciHelper().constructConfigurationItem(Directory.class, $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().nextId());
                    Parent ci = (Parent)((Object)((Object)((Object)((Object)((RepositoryFactory)((Object)$this)).ciHelper().constructCi(CiHelper$.MODULE$.classToType(Parent.class), $this.com$xebialabs$xlplatform$xlrepository$tck$suites$RepositoryStructuralIntegritySuite$$gen().subId((ConfigurationItem)dir))))));
                    $this.an(ClassTag$.MODULE$.apply(Exception.class)).shouldBe($this.thrownBy((Function0)(JFunction0.mcV.sp & Serializable)() -> ((RepositoryFactory)((Object)$this)).repository().create((ConfigurationItem[])new Parent[]{ci})), Prettifier$.MODULE$.default(), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
                    return $this.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)((RepositoryFactory)((Object)$this)).repository().exists(ci.getId())), new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269), Prettifier$.MODULE$.default()).shouldEqual((Object)BoxesRunTime.boxToBoolean((boolean)false), Equality$.MODULE$.default());
                }, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
            }, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
        }, new Position("RepositoryStructuralIntegritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 21));
    }
}

