package com.xebialabs.xlplatform.xlrepository.tck.util

import java.util.concurrent.atomic.AtomicInteger

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot

import scala.collection.mutable.{Map => MMap}

object IdGenerator {
  val counter: MMap[String, AtomicInteger] = MMap()
}

class IdGenerator(val baseId: String) {

  def this(configurationItemRoot: ConfigurationItemRoot) = this(configurationItemRoot.getRootNodeName)

  def genFor(id: String) = new IdGenerator(s"$baseId/$id")

  def nextId() = s"$baseId-${_nextId(baseId)}"

  def subId(ci: ConfigurationItem) = s"${ci.getId}/sub-${_nextId(ci.getId)}"

  private[this] def _nextId(k: String) = IdGenerator.counter.getOrElseUpdate(k, new AtomicInteger(0)).incrementAndGet()
}
